/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceTypeListCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveryModification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoveredDeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiscoveredDeviceSummary> {
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceId").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::connectorDeviceId)).setter(DiscoveredDeviceSummary.setter(Builder::connectorDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()}).build();
    private static final SdkField<String> CONNECTOR_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceName").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::connectorDeviceName)).setter(DiscoveredDeviceSummary.setter(Builder::connectorDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceName").build()}).build();
    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceTypes").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::deviceTypes)).setter(DiscoveredDeviceSummary.setter(Builder::deviceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedThingId").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::managedThingId)).setter(DiscoveredDeviceSummary.setter(Builder::managedThingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()}).build();
    private static final SdkField<String> MODIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Modification").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::modificationAsString)).setter(DiscoveredDeviceSummary.setter(Builder::modification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Modification").build()}).build();
    private static final SdkField<Instant> DISCOVERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DiscoveredAt").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::discoveredAt)).setter(DiscoveredDeviceSummary.setter(Builder::discoveredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveredAt").build()}).build();
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::brand)).setter(DiscoveredDeviceSummary.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::model)).setter(DiscoveredDeviceSummary.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> AUTHENTICATION_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMaterial").getter(DiscoveredDeviceSummary.getter(DiscoveredDeviceSummary::authenticationMaterial)).setter(DiscoveredDeviceSummary.setter(Builder::authenticationMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterial").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DEVICE_ID_FIELD, CONNECTOR_DEVICE_NAME_FIELD, DEVICE_TYPES_FIELD, MANAGED_THING_ID_FIELD, MODIFICATION_FIELD, DISCOVERED_AT_FIELD, BRAND_FIELD, MODEL_FIELD, AUTHENTICATION_MATERIAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiscoveredDeviceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectorDeviceId;
    private final String connectorDeviceName;
    private final List<String> deviceTypes;
    private final String managedThingId;
    private final String modification;
    private final Instant discoveredAt;
    private final String brand;
    private final String model;
    private final String authenticationMaterial;

    private DiscoveredDeviceSummary(BuilderImpl builder) {
        this.connectorDeviceId = builder.connectorDeviceId;
        this.connectorDeviceName = builder.connectorDeviceName;
        this.deviceTypes = builder.deviceTypes;
        this.managedThingId = builder.managedThingId;
        this.modification = builder.modification;
        this.discoveredAt = builder.discoveredAt;
        this.brand = builder.brand;
        this.model = builder.model;
        this.authenticationMaterial = builder.authenticationMaterial;
    }

    public final String connectorDeviceId() {
        return this.connectorDeviceId;
    }

    public final String connectorDeviceName() {
        return this.connectorDeviceName;
    }

    public final boolean hasDeviceTypes() {
        return this.deviceTypes != null && !(this.deviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> deviceTypes() {
        return this.deviceTypes;
    }

    public final String managedThingId() {
        return this.managedThingId;
    }

    public final DiscoveryModification modification() {
        return DiscoveryModification.fromValue(this.modification);
    }

    public final String modificationAsString() {
        return this.modification;
    }

    public final Instant discoveredAt() {
        return this.discoveredAt;
    }

    public final String brand() {
        return this.brand;
    }

    public final String model() {
        return this.model;
    }

    public final String authenticationMaterial() {
        return this.authenticationMaterial;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTypes() ? this.deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.brand());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMaterial());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveredDeviceSummary)) {
            return false;
        }
        DiscoveredDeviceSummary other = (DiscoveredDeviceSummary)obj;
        return Objects.equals(this.connectorDeviceId(), other.connectorDeviceId()) && Objects.equals(this.connectorDeviceName(), other.connectorDeviceName()) && this.hasDeviceTypes() == other.hasDeviceTypes() && Objects.equals(this.deviceTypes(), other.deviceTypes()) && Objects.equals(this.managedThingId(), other.managedThingId()) && Objects.equals(this.modificationAsString(), other.modificationAsString()) && Objects.equals(this.discoveredAt(), other.discoveredAt()) && Objects.equals(this.brand(), other.brand()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.authenticationMaterial(), other.authenticationMaterial());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoveredDeviceSummary").add("ConnectorDeviceId", (Object)(this.connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectorDeviceName", (Object)(this.connectorDeviceName() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceTypes", this.hasDeviceTypes() ? this.deviceTypes() : null).add("ManagedThingId", (Object)this.managedThingId()).add("Modification", (Object)this.modificationAsString()).add("DiscoveredAt", (Object)this.discoveredAt()).add("Brand", (Object)(this.brand() == null ? null : "*** Sensitive Data Redacted ***")).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthenticationMaterial", (Object)(this.authenticationMaterial() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorDeviceId": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceId()));
            }
            case "ConnectorDeviceName": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceName()));
            }
            case "DeviceTypes": {
                return Optional.ofNullable(clazz.cast(this.deviceTypes()));
            }
            case "ManagedThingId": {
                return Optional.ofNullable(clazz.cast(this.managedThingId()));
            }
            case "Modification": {
                return Optional.ofNullable(clazz.cast(this.modificationAsString()));
            }
            case "DiscoveredAt": {
                return Optional.ofNullable(clazz.cast(this.discoveredAt()));
            }
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brand()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "AuthenticationMaterial": {
                return Optional.ofNullable(clazz.cast(this.authenticationMaterial()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("ConnectorDeviceName", CONNECTOR_DEVICE_NAME_FIELD);
        map.put("DeviceTypes", DEVICE_TYPES_FIELD);
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Modification", MODIFICATION_FIELD);
        map.put("DiscoveredAt", DISCOVERED_AT_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("AuthenticationMaterial", AUTHENTICATION_MATERIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoveredDeviceSummary, T> g) {
        return obj -> g.apply((DiscoveredDeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorDeviceId;
        private String connectorDeviceName;
        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();
        private String managedThingId;
        private String modification;
        private Instant discoveredAt;
        private String brand;
        private String model;
        private String authenticationMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveredDeviceSummary model) {
            this.connectorDeviceId(model.connectorDeviceId);
            this.connectorDeviceName(model.connectorDeviceName);
            this.deviceTypes(model.deviceTypes);
            this.managedThingId(model.managedThingId);
            this.modification(model.modification);
            this.discoveredAt(model.discoveredAt);
            this.brand(model.brand);
            this.model(model.model);
            this.authenticationMaterial(model.authenticationMaterial);
        }

        public final String getConnectorDeviceId() {
            return this.connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getConnectorDeviceName() {
            return this.connectorDeviceName;
        }

        public final void setConnectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
        }

        @Override
        public final Builder connectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (this.deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String ... deviceTypes) {
            this.deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final String getManagedThingId() {
            return this.managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final String getModification() {
            return this.modification;
        }

        public final void setModification(String modification) {
            this.modification = modification;
        }

        @Override
        public final Builder modification(String modification) {
            this.modification = modification;
            return this;
        }

        @Override
        public final Builder modification(DiscoveryModification modification) {
            this.modification(modification == null ? null : modification.toString());
            return this;
        }

        public final Instant getDiscoveredAt() {
            return this.discoveredAt;
        }

        public final void setDiscoveredAt(Instant discoveredAt) {
            this.discoveredAt = discoveredAt;
        }

        @Override
        public final Builder discoveredAt(Instant discoveredAt) {
            this.discoveredAt = discoveredAt;
            return this;
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getAuthenticationMaterial() {
            return this.authenticationMaterial;
        }

        public final void setAuthenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
        }

        @Override
        public final Builder authenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
            return this;
        }

        public DiscoveredDeviceSummary build() {
            return new DiscoveredDeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiscoveredDeviceSummary> {
        public Builder connectorDeviceId(String var1);

        public Builder connectorDeviceName(String var1);

        public Builder deviceTypes(Collection<String> var1);

        public Builder deviceTypes(String ... var1);

        public Builder managedThingId(String var1);

        public Builder modification(String var1);

        public Builder modification(DiscoveryModification var1);

        public Builder discoveredAt(Instant var1);

        public Builder brand(String var1);

        public Builder model(String var1);

        public Builder authenticationMaterial(String var1);
    }
}

