/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ManagedThingAssociation;

public class ListManagedThingAccountAssociationsIterable
implements SdkIterable<ListManagedThingAccountAssociationsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListManagedThingAccountAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedThingAccountAssociationsIterable(IotManagedIntegrationsClient client, ListManagedThingAccountAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedThingAccountAssociationsResponseFetcher();
    }

    public Iterator<ListManagedThingAccountAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedThingAssociation> items() {
        Function<ListManagedThingAccountAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedThingAccountAssociationsResponseFetcher
    implements SyncPageFetcher<ListManagedThingAccountAssociationsResponse> {
        private ListManagedThingAccountAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedThingAccountAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedThingAccountAssociationsResponse nextPage(ListManagedThingAccountAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedThingAccountAssociationsIterable.this.client.listManagedThingAccountAssociations(ListManagedThingAccountAssociationsIterable.this.firstRequest);
            }
            return ListManagedThingAccountAssociationsIterable.this.client.listManagedThingAccountAssociations((ListManagedThingAccountAssociationsRequest)((Object)ListManagedThingAccountAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

