/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceDiscoverySummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse;

public class ListDeviceDiscoveriesIterable
implements SdkIterable<ListDeviceDiscoveriesResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListDeviceDiscoveriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceDiscoveriesIterable(IotManagedIntegrationsClient client, ListDeviceDiscoveriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeviceDiscoveriesResponseFetcher();
    }

    public Iterator<ListDeviceDiscoveriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceDiscoverySummary> items() {
        Function<ListDeviceDiscoveriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeviceDiscoveriesResponseFetcher
    implements SyncPageFetcher<ListDeviceDiscoveriesResponse> {
        private ListDeviceDiscoveriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceDiscoveriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceDiscoveriesResponse nextPage(ListDeviceDiscoveriesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceDiscoveriesIterable.this.client.listDeviceDiscoveries(ListDeviceDiscoveriesIterable.this.firstRequest);
            }
            return ListDeviceDiscoveriesIterable.this.client.listDeviceDiscoveries((ListDeviceDiscoveriesRequest)((Object)ListDeviceDiscoveriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

