/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpoint;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpointsCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendManagedThingCommandRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, SendManagedThingCommandRequest> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedThingId").getter(SendManagedThingCommandRequest.getter(SendManagedThingCommandRequest::managedThingId)).setter(SendManagedThingCommandRequest.setter(Builder::managedThingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagedThingId").build()}).build();
    private static final SdkField<List<CommandEndpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(SendManagedThingCommandRequest.getter(SendManagedThingCommandRequest::endpoints)).setter(SendManagedThingCommandRequest.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorAssociationId").getter(SendManagedThingCommandRequest.getter(SendManagedThingCommandRequest::connectorAssociationId)).setter(SendManagedThingCommandRequest.setter(Builder::connectorAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorAssociationId").build()}).build();
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssociationId").getter(SendManagedThingCommandRequest.getter(SendManagedThingCommandRequest::accountAssociationId)).setter(SendManagedThingCommandRequest.setter(Builder::accountAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD, ENDPOINTS_FIELD, CONNECTOR_ASSOCIATION_ID_FIELD, ACCOUNT_ASSOCIATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendManagedThingCommandRequest.memberNameToFieldInitializer();
    private final String managedThingId;
    private final List<CommandEndpoint> endpoints;
    private final String connectorAssociationId;
    private final String accountAssociationId;

    private SendManagedThingCommandRequest(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.endpoints = builder.endpoints;
        this.connectorAssociationId = builder.connectorAssociationId;
        this.accountAssociationId = builder.accountAssociationId;
    }

    public final String managedThingId() {
        return this.managedThingId;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<CommandEndpoint> endpoints() {
        return this.endpoints;
    }

    @Deprecated
    public final String connectorAssociationId() {
        return this.connectorAssociationId;
    }

    public final String accountAssociationId() {
        return this.accountAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssociationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendManagedThingCommandRequest)) {
            return false;
        }
        SendManagedThingCommandRequest other = (SendManagedThingCommandRequest)((Object)obj);
        return Objects.equals(this.managedThingId(), other.managedThingId()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.connectorAssociationId(), other.connectorAssociationId()) && Objects.equals(this.accountAssociationId(), other.accountAssociationId());
    }

    public final String toString() {
        return ToString.builder((String)"SendManagedThingCommandRequest").add("ManagedThingId", (Object)this.managedThingId()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ConnectorAssociationId", (Object)this.connectorAssociationId()).add("AccountAssociationId", (Object)this.accountAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedThingId": {
                return Optional.ofNullable(clazz.cast(this.managedThingId()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "ConnectorAssociationId": {
                return Optional.ofNullable(clazz.cast(this.connectorAssociationId()));
            }
            case "AccountAssociationId": {
                return Optional.ofNullable(clazz.cast(this.accountAssociationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("ConnectorAssociationId", CONNECTOR_ASSOCIATION_ID_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendManagedThingCommandRequest, T> g) {
        return obj -> g.apply((SendManagedThingCommandRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String managedThingId;
        private List<CommandEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private String connectorAssociationId;
        private String accountAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendManagedThingCommandRequest model) {
            super(model);
            this.managedThingId(model.managedThingId);
            this.endpoints(model.endpoints);
            this.connectorAssociationId(model.connectorAssociationId);
            this.accountAssociationId(model.accountAssociationId);
        }

        public final String getManagedThingId() {
            return this.managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final List<CommandEndpoint.Builder> getEndpoints() {
            List<CommandEndpoint.Builder> result = CommandEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<CommandEndpoint.BuilderImpl> endpoints) {
            this.endpoints = CommandEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<CommandEndpoint> endpoints) {
            this.endpoints = CommandEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(CommandEndpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<CommandEndpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (CommandEndpoint)((CommandEndpoint.Builder)CommandEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getConnectorAssociationId() {
            return this.connectorAssociationId;
        }

        @Deprecated
        public final void setConnectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
        }

        @Override
        @Deprecated
        public final Builder connectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
            return this;
        }

        public final String getAccountAssociationId() {
            return this.accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendManagedThingCommandRequest build() {
            return new SendManagedThingCommandRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendManagedThingCommandRequest> {
        public Builder managedThingId(String var1);

        public Builder endpoints(Collection<CommandEndpoint> var1);

        public Builder endpoints(CommandEndpoint ... var1);

        public Builder endpoints(Consumer<CommandEndpoint.Builder> ... var1);

        @Deprecated
        public Builder connectorAssociationId(String var1);

        public Builder accountAssociationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

