/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskConfigurationSummary;

public class ListOtaTaskConfigurationsIterable
implements SdkIterable<ListOtaTaskConfigurationsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListOtaTaskConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOtaTaskConfigurationsIterable(IotManagedIntegrationsClient client, ListOtaTaskConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOtaTaskConfigurationsResponseFetcher();
    }

    public Iterator<ListOtaTaskConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OtaTaskConfigurationSummary> items() {
        Function<ListOtaTaskConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOtaTaskConfigurationsResponseFetcher
    implements SyncPageFetcher<ListOtaTaskConfigurationsResponse> {
        private ListOtaTaskConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTaskConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOtaTaskConfigurationsResponse nextPage(ListOtaTaskConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTaskConfigurationsIterable.this.client.listOtaTaskConfigurations(ListOtaTaskConfigurationsIterable.this.firstRequest);
            }
            return ListOtaTaskConfigurationsIterable.this.client.listOtaTaskConfigurations((ListOtaTaskConfigurationsRequest)((Object)ListOtaTaskConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

