/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskSummary;

public class ListOtaTasksIterable
implements SdkIterable<ListOtaTasksResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListOtaTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOtaTasksIterable(IotManagedIntegrationsClient client, ListOtaTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOtaTasksResponseFetcher();
    }

    public Iterator<ListOtaTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OtaTaskSummary> tasks() {
        Function<ListOtaTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOtaTasksResponseFetcher
    implements SyncPageFetcher<ListOtaTasksResponse> {
        private ListOtaTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOtaTasksResponse nextPage(ListOtaTasksResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTasksIterable.this.client.listOtaTasks(ListOtaTasksIterable.this.firstRequest);
            }
            return ListOtaTasksIterable.this.client.listOtaTasks((ListOtaTasksRequest)((Object)ListOtaTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

