/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EventLogConfigurationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse;

public class ListEventLogConfigurationsIterable
implements SdkIterable<ListEventLogConfigurationsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListEventLogConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventLogConfigurationsIterable(IotManagedIntegrationsClient client, ListEventLogConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventLogConfigurationsResponseFetcher();
    }

    public Iterator<ListEventLogConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventLogConfigurationSummary> eventLogConfigurationList() {
        Function<ListEventLogConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventLogConfigurationList() != null) {
                return response.eventLogConfigurationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventLogConfigurationsResponseFetcher
    implements SyncPageFetcher<ListEventLogConfigurationsResponse> {
        private ListEventLogConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventLogConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventLogConfigurationsResponse nextPage(ListEventLogConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventLogConfigurationsIterable.this.client.listEventLogConfigurations(ListEventLogConfigurationsIterable.this.firstRequest);
            }
            return ListEventLogConfigurationsIterable.this.client.listEventLogConfigurations((ListEventLogConfigurationsRequest)((Object)ListEventLogConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

