/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CredentialLockerSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse;

public class ListCredentialLockersPublisher
implements SdkPublisher<ListCredentialLockersResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListCredentialLockersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCredentialLockersPublisher(IotManagedIntegrationsAsyncClient client, ListCredentialLockersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCredentialLockersPublisher(IotManagedIntegrationsAsyncClient client, ListCredentialLockersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCredentialLockersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCredentialLockersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CredentialLockerSummary> items() {
        Function<ListCredentialLockersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCredentialLockersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCredentialLockersResponseFetcher
    implements AsyncPageFetcher<ListCredentialLockersResponse> {
        private ListCredentialLockersResponseFetcher() {
        }

        public boolean hasNextPage(ListCredentialLockersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCredentialLockersResponse> nextPage(ListCredentialLockersResponse previousPage) {
            if (previousPage == null) {
                return ListCredentialLockersPublisher.this.client.listCredentialLockers(ListCredentialLockersPublisher.this.firstRequest);
            }
            return ListCredentialLockersPublisher.this.client.listCredentialLockers((ListCredentialLockersRequest)((Object)ListCredentialLockersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

