/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OtaTaskExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OtaTaskExecutionSummary> {
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ExecutionNumber").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::executionNumber)).setter(OtaTaskExecutionSummary.setter(Builder::executionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionNumber").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::lastUpdatedAt)).setter(OtaTaskExecutionSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QueuedAt").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::queuedAt)).setter(OtaTaskExecutionSummary.setter(Builder::queuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuedAt").build()}).build();
    private static final SdkField<Integer> RETRY_ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryAttempt").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::retryAttempt)).setter(OtaTaskExecutionSummary.setter(Builder::retryAttempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::startedAt)).setter(OtaTaskExecutionSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OtaTaskExecutionSummary.getter(OtaTaskExecutionSummary::statusAsString)).setter(OtaTaskExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_NUMBER_FIELD, LAST_UPDATED_AT_FIELD, QUEUED_AT_FIELD, RETRY_ATTEMPT_FIELD, STARTED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OtaTaskExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long executionNumber;
    private final Instant lastUpdatedAt;
    private final Instant queuedAt;
    private final Integer retryAttempt;
    private final Instant startedAt;
    private final String status;

    private OtaTaskExecutionSummary(BuilderImpl builder) {
        this.executionNumber = builder.executionNumber;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.queuedAt = builder.queuedAt;
        this.retryAttempt = builder.retryAttempt;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
    }

    public final Long executionNumber() {
        return this.executionNumber;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant queuedAt() {
        return this.queuedAt;
    }

    public final Integer retryAttempt() {
        return this.retryAttempt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final OtaTaskExecutionStatus status() {
        return OtaTaskExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskExecutionSummary)) {
            return false;
        }
        OtaTaskExecutionSummary other = (OtaTaskExecutionSummary)obj;
        return Objects.equals(this.executionNumber(), other.executionNumber()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.queuedAt(), other.queuedAt()) && Objects.equals(this.retryAttempt(), other.retryAttempt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OtaTaskExecutionSummary").add("ExecutionNumber", (Object)this.executionNumber()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("QueuedAt", (Object)this.queuedAt()).add("RetryAttempt", (Object)this.retryAttempt()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionNumber": {
                return Optional.ofNullable(clazz.cast(this.executionNumber()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "QueuedAt": {
                return Optional.ofNullable(clazz.cast(this.queuedAt()));
            }
            case "RetryAttempt": {
                return Optional.ofNullable(clazz.cast(this.retryAttempt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionNumber", EXECUTION_NUMBER_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("QueuedAt", QUEUED_AT_FIELD);
        map.put("RetryAttempt", RETRY_ATTEMPT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskExecutionSummary, T> g) {
        return obj -> g.apply((OtaTaskExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long executionNumber;
        private Instant lastUpdatedAt;
        private Instant queuedAt;
        private Integer retryAttempt;
        private Instant startedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskExecutionSummary model) {
            this.executionNumber(model.executionNumber);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.queuedAt(model.queuedAt);
            this.retryAttempt(model.retryAttempt);
            this.startedAt(model.startedAt);
            this.status(model.status);
        }

        public final Long getExecutionNumber() {
            return this.executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getQueuedAt() {
            return this.queuedAt;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Integer getRetryAttempt() {
            return this.retryAttempt;
        }

        public final void setRetryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Override
        public final Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaTaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public OtaTaskExecutionSummary build() {
            return new OtaTaskExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OtaTaskExecutionSummary> {
        public Builder executionNumber(Long var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder queuedAt(Instant var1);

        public Builder retryAttempt(Integer var1);

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(OtaTaskExecutionStatus var1);
    }
}

