/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummary;
import software.amazon.awssdk.services.iotjobsdataplane.model.JobExecutionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPendingJobExecutionsResponse
extends IotJobsDataPlaneResponse
implements ToCopyableBuilder<Builder, GetPendingJobExecutionsResponse> {
    private static final SdkField<List<JobExecutionSummary>> IN_PROGRESS_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inProgressJobs").getter(GetPendingJobExecutionsResponse.getter(GetPendingJobExecutionsResponse::inProgressJobs)).setter(GetPendingJobExecutionsResponse.setter(Builder::inProgressJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<JobExecutionSummary>> QUEUED_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queuedJobs").getter(GetPendingJobExecutionsResponse.getter(GetPendingJobExecutionsResponse::queuedJobs)).setter(GetPendingJobExecutionsResponse.setter(Builder::queuedJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IN_PROGRESS_JOBS_FIELD, QUEUED_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPendingJobExecutionsResponse.memberNameToFieldInitializer();
    private final List<JobExecutionSummary> inProgressJobs;
    private final List<JobExecutionSummary> queuedJobs;

    private GetPendingJobExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.inProgressJobs = builder.inProgressJobs;
        this.queuedJobs = builder.queuedJobs;
    }

    public final boolean hasInProgressJobs() {
        return this.inProgressJobs != null && !(this.inProgressJobs instanceof SdkAutoConstructList);
    }

    public final List<JobExecutionSummary> inProgressJobs() {
        return this.inProgressJobs;
    }

    public final boolean hasQueuedJobs() {
        return this.queuedJobs != null && !(this.queuedJobs instanceof SdkAutoConstructList);
    }

    public final List<JobExecutionSummary> queuedJobs() {
        return this.queuedJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInProgressJobs() ? this.inProgressJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueuedJobs() ? this.queuedJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPendingJobExecutionsResponse)) {
            return false;
        }
        GetPendingJobExecutionsResponse other = (GetPendingJobExecutionsResponse)((Object)obj);
        return this.hasInProgressJobs() == other.hasInProgressJobs() && Objects.equals(this.inProgressJobs(), other.inProgressJobs()) && this.hasQueuedJobs() == other.hasQueuedJobs() && Objects.equals(this.queuedJobs(), other.queuedJobs());
    }

    public final String toString() {
        return ToString.builder((String)"GetPendingJobExecutionsResponse").add("InProgressJobs", this.hasInProgressJobs() ? this.inProgressJobs() : null).add("QueuedJobs", this.hasQueuedJobs() ? this.queuedJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inProgressJobs": {
                return Optional.ofNullable(clazz.cast(this.inProgressJobs()));
            }
            case "queuedJobs": {
                return Optional.ofNullable(clazz.cast(this.queuedJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<JobExecutionSummary>>> map = new HashMap<String, SdkField<List<JobExecutionSummary>>>();
        map.put("inProgressJobs", IN_PROGRESS_JOBS_FIELD);
        map.put("queuedJobs", QUEUED_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPendingJobExecutionsResponse, T> g) {
        return obj -> g.apply((GetPendingJobExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotJobsDataPlaneResponse.BuilderImpl
    implements Builder {
        private List<JobExecutionSummary> inProgressJobs = DefaultSdkAutoConstructList.getInstance();
        private List<JobExecutionSummary> queuedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPendingJobExecutionsResponse model) {
            super(model);
            this.inProgressJobs(model.inProgressJobs);
            this.queuedJobs(model.queuedJobs);
        }

        public final List<JobExecutionSummary.Builder> getInProgressJobs() {
            List<JobExecutionSummary.Builder> result = JobExecutionSummaryListCopier.copyToBuilder(this.inProgressJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInProgressJobs(Collection<JobExecutionSummary.BuilderImpl> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copyFromBuilder(inProgressJobs);
        }

        @Override
        public final Builder inProgressJobs(Collection<JobExecutionSummary> inProgressJobs) {
            this.inProgressJobs = JobExecutionSummaryListCopier.copy(inProgressJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(JobExecutionSummary ... inProgressJobs) {
            this.inProgressJobs(Arrays.asList(inProgressJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inProgressJobs(Consumer<JobExecutionSummary.Builder> ... inProgressJobs) {
            this.inProgressJobs(Stream.of(inProgressJobs).map(c -> (JobExecutionSummary)((JobExecutionSummary.Builder)JobExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<JobExecutionSummary.Builder> getQueuedJobs() {
            List<JobExecutionSummary.Builder> result = JobExecutionSummaryListCopier.copyToBuilder(this.queuedJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueuedJobs(Collection<JobExecutionSummary.BuilderImpl> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copyFromBuilder(queuedJobs);
        }

        @Override
        public final Builder queuedJobs(Collection<JobExecutionSummary> queuedJobs) {
            this.queuedJobs = JobExecutionSummaryListCopier.copy(queuedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(JobExecutionSummary ... queuedJobs) {
            this.queuedJobs(Arrays.asList(queuedJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queuedJobs(Consumer<JobExecutionSummary.Builder> ... queuedJobs) {
            this.queuedJobs(Stream.of(queuedJobs).map(c -> (JobExecutionSummary)((JobExecutionSummary.Builder)JobExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPendingJobExecutionsResponse build() {
            return new GetPendingJobExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotJobsDataPlaneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPendingJobExecutionsResponse> {
        public Builder inProgressJobs(Collection<JobExecutionSummary> var1);

        public Builder inProgressJobs(JobExecutionSummary ... var1);

        public Builder inProgressJobs(Consumer<JobExecutionSummary.Builder> ... var1);

        public Builder queuedJobs(Collection<JobExecutionSummary> var1);

        public Builder queuedJobs(JobExecutionSummary ... var1);

        public Builder queuedJobs(Consumer<JobExecutionSummary.Builder> ... var1);
    }
}

