/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegistrationStatus;
import software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRegisterAccountStatusResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, GetRegisterAccountStatusResponse> {
    private static final SdkField<String> CUSTOMER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerAccountId").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::customerAccountId)).setter(GetRegisterAccountStatusResponse.setter(Builder::customerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAccountId").build()}).build();
    private static final SdkField<String> ACCOUNT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountStatus").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::accountStatusAsString)).setter(GetRegisterAccountStatusResponse.setter(Builder::accountStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountStatus").build()}).build();
    private static final SdkField<TimestreamRegistrationResponse> TIMESTREAM_REGISTRATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestreamRegistrationResponse").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::timestreamRegistrationResponse)).setter(GetRegisterAccountStatusResponse.setter(Builder::timestreamRegistrationResponse)).constructor(TimestreamRegistrationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamRegistrationResponse").build()}).build();
    private static final SdkField<IamRegistrationResponse> IAM_REGISTRATION_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamRegistrationResponse").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::iamRegistrationResponse)).setter(GetRegisterAccountStatusResponse.setter(Builder::iamRegistrationResponse)).constructor(IamRegistrationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRegistrationResponse").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::creationTime)).setter(GetRegisterAccountStatusResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModificationTime").getter(GetRegisterAccountStatusResponse.getter(GetRegisterAccountStatusResponse::lastModificationTime)).setter(GetRegisterAccountStatusResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ACCOUNT_ID_FIELD, ACCOUNT_STATUS_FIELD, TIMESTREAM_REGISTRATION_RESPONSE_FIELD, IAM_REGISTRATION_RESPONSE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRegisterAccountStatusResponse.memberNameToFieldInitializer();
    private final String customerAccountId;
    private final String accountStatus;
    private final TimestreamRegistrationResponse timestreamRegistrationResponse;
    private final IamRegistrationResponse iamRegistrationResponse;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private GetRegisterAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.customerAccountId = builder.customerAccountId;
        this.accountStatus = builder.accountStatus;
        this.timestreamRegistrationResponse = builder.timestreamRegistrationResponse;
        this.iamRegistrationResponse = builder.iamRegistrationResponse;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String customerAccountId() {
        return this.customerAccountId;
    }

    public final RegistrationStatus accountStatus() {
        return RegistrationStatus.fromValue(this.accountStatus);
    }

    public final String accountStatusAsString() {
        return this.accountStatus;
    }

    public final TimestreamRegistrationResponse timestreamRegistrationResponse() {
        return this.timestreamRegistrationResponse;
    }

    public final IamRegistrationResponse iamRegistrationResponse() {
        return this.iamRegistrationResponse;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestreamRegistrationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRegistrationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegisterAccountStatusResponse)) {
            return false;
        }
        GetRegisterAccountStatusResponse other = (GetRegisterAccountStatusResponse)((Object)obj);
        return Objects.equals(this.customerAccountId(), other.customerAccountId()) && Objects.equals(this.accountStatusAsString(), other.accountStatusAsString()) && Objects.equals(this.timestreamRegistrationResponse(), other.timestreamRegistrationResponse()) && Objects.equals(this.iamRegistrationResponse(), other.iamRegistrationResponse()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetRegisterAccountStatusResponse").add("CustomerAccountId", (Object)this.customerAccountId()).add("AccountStatus", (Object)this.accountStatusAsString()).add("TimestreamRegistrationResponse", (Object)this.timestreamRegistrationResponse()).add("IamRegistrationResponse", (Object)this.iamRegistrationResponse()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerAccountId": {
                return Optional.ofNullable(clazz.cast(this.customerAccountId()));
            }
            case "accountStatus": {
                return Optional.ofNullable(clazz.cast(this.accountStatusAsString()));
            }
            case "timestreamRegistrationResponse": {
                return Optional.ofNullable(clazz.cast(this.timestreamRegistrationResponse()));
            }
            case "iamRegistrationResponse": {
                return Optional.ofNullable(clazz.cast(this.iamRegistrationResponse()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerAccountId", CUSTOMER_ACCOUNT_ID_FIELD);
        map.put("accountStatus", ACCOUNT_STATUS_FIELD);
        map.put("timestreamRegistrationResponse", TIMESTREAM_REGISTRATION_RESPONSE_FIELD);
        map.put("iamRegistrationResponse", IAM_REGISTRATION_RESPONSE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRegisterAccountStatusResponse, T> g) {
        return obj -> g.apply((GetRegisterAccountStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private String customerAccountId;
        private String accountStatus;
        private TimestreamRegistrationResponse timestreamRegistrationResponse;
        private IamRegistrationResponse iamRegistrationResponse;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegisterAccountStatusResponse model) {
            super(model);
            this.customerAccountId(model.customerAccountId);
            this.accountStatus(model.accountStatus);
            this.timestreamRegistrationResponse(model.timestreamRegistrationResponse);
            this.iamRegistrationResponse(model.iamRegistrationResponse);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getCustomerAccountId() {
            return this.customerAccountId;
        }

        public final void setCustomerAccountId(String customerAccountId) {
            this.customerAccountId = customerAccountId;
        }

        @Override
        public final Builder customerAccountId(String customerAccountId) {
            this.customerAccountId = customerAccountId;
            return this;
        }

        public final String getAccountStatus() {
            return this.accountStatus;
        }

        public final void setAccountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
        }

        @Override
        public final Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        @Override
        public final Builder accountStatus(RegistrationStatus accountStatus) {
            this.accountStatus(accountStatus == null ? null : accountStatus.toString());
            return this;
        }

        public final TimestreamRegistrationResponse.Builder getTimestreamRegistrationResponse() {
            return this.timestreamRegistrationResponse != null ? this.timestreamRegistrationResponse.toBuilder() : null;
        }

        public final void setTimestreamRegistrationResponse(TimestreamRegistrationResponse.BuilderImpl timestreamRegistrationResponse) {
            this.timestreamRegistrationResponse = timestreamRegistrationResponse != null ? timestreamRegistrationResponse.build() : null;
        }

        @Override
        public final Builder timestreamRegistrationResponse(TimestreamRegistrationResponse timestreamRegistrationResponse) {
            this.timestreamRegistrationResponse = timestreamRegistrationResponse;
            return this;
        }

        public final IamRegistrationResponse.Builder getIamRegistrationResponse() {
            return this.iamRegistrationResponse != null ? this.iamRegistrationResponse.toBuilder() : null;
        }

        public final void setIamRegistrationResponse(IamRegistrationResponse.BuilderImpl iamRegistrationResponse) {
            this.iamRegistrationResponse = iamRegistrationResponse != null ? iamRegistrationResponse.build() : null;
        }

        @Override
        public final Builder iamRegistrationResponse(IamRegistrationResponse iamRegistrationResponse) {
            this.iamRegistrationResponse = iamRegistrationResponse;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public GetRegisterAccountStatusResponse build() {
            return new GetRegisterAccountStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRegisterAccountStatusResponse> {
        public Builder customerAccountId(String var1);

        public Builder accountStatus(String var1);

        public Builder accountStatus(RegistrationStatus var1);

        public Builder timestreamRegistrationResponse(TimestreamRegistrationResponse var1);

        default public Builder timestreamRegistrationResponse(Consumer<TimestreamRegistrationResponse.Builder> timestreamRegistrationResponse) {
            return this.timestreamRegistrationResponse((TimestreamRegistrationResponse)((TimestreamRegistrationResponse.Builder)TimestreamRegistrationResponse.builder().applyMutation(timestreamRegistrationResponse)).build());
        }

        public Builder iamRegistrationResponse(IamRegistrationResponse var1);

        default public Builder iamRegistrationResponse(Consumer<IamRegistrationResponse.Builder> iamRegistrationResponse) {
            return this.iamRegistrationResponse((IamRegistrationResponse)((IamRegistrationResponse.Builder)IamRegistrationResponse.builder().applyMutation(iamRegistrationResponse)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

