/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.StorageMaximumSize;
import software.amazon.awssdk.services.iotfleetwise.model.StorageMinimumTimeToLive;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPartitionStorageOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPartitionStorageOptions> {
    private static final SdkField<StorageMaximumSize> MAXIMUM_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maximumSize").getter(DataPartitionStorageOptions.getter(DataPartitionStorageOptions::maximumSize)).setter(DataPartitionStorageOptions.setter(Builder::maximumSize)).constructor(StorageMaximumSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumSize").build()}).build();
    private static final SdkField<String> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageLocation").getter(DataPartitionStorageOptions.getter(DataPartitionStorageOptions::storageLocation)).setter(DataPartitionStorageOptions.setter(Builder::storageLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()}).build();
    private static final SdkField<StorageMinimumTimeToLive> MINIMUM_TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("minimumTimeToLive").getter(DataPartitionStorageOptions.getter(DataPartitionStorageOptions::minimumTimeToLive)).setter(DataPartitionStorageOptions.setter(Builder::minimumTimeToLive)).constructor(StorageMinimumTimeToLive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumTimeToLive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_SIZE_FIELD, STORAGE_LOCATION_FIELD, MINIMUM_TIME_TO_LIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataPartitionStorageOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StorageMaximumSize maximumSize;
    private final String storageLocation;
    private final StorageMinimumTimeToLive minimumTimeToLive;

    private DataPartitionStorageOptions(BuilderImpl builder) {
        this.maximumSize = builder.maximumSize;
        this.storageLocation = builder.storageLocation;
        this.minimumTimeToLive = builder.minimumTimeToLive;
    }

    public final StorageMaximumSize maximumSize() {
        return this.maximumSize;
    }

    public final String storageLocation() {
        return this.storageLocation;
    }

    public final StorageMinimumTimeToLive minimumTimeToLive() {
        return this.minimumTimeToLive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumTimeToLive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPartitionStorageOptions)) {
            return false;
        }
        DataPartitionStorageOptions other = (DataPartitionStorageOptions)obj;
        return Objects.equals(this.maximumSize(), other.maximumSize()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.minimumTimeToLive(), other.minimumTimeToLive());
    }

    public final String toString() {
        return ToString.builder((String)"DataPartitionStorageOptions").add("MaximumSize", (Object)this.maximumSize()).add("StorageLocation", (Object)(this.storageLocation() == null ? null : "*** Sensitive Data Redacted ***")).add("MinimumTimeToLive", (Object)this.minimumTimeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximumSize": {
                return Optional.ofNullable(clazz.cast(this.maximumSize()));
            }
            case "storageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "minimumTimeToLive": {
                return Optional.ofNullable(clazz.cast(this.minimumTimeToLive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maximumSize", MAXIMUM_SIZE_FIELD);
        map.put("storageLocation", STORAGE_LOCATION_FIELD);
        map.put("minimumTimeToLive", MINIMUM_TIME_TO_LIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPartitionStorageOptions, T> g) {
        return obj -> g.apply((DataPartitionStorageOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StorageMaximumSize maximumSize;
        private String storageLocation;
        private StorageMinimumTimeToLive minimumTimeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPartitionStorageOptions model) {
            this.maximumSize(model.maximumSize);
            this.storageLocation(model.storageLocation);
            this.minimumTimeToLive(model.minimumTimeToLive);
        }

        public final StorageMaximumSize.Builder getMaximumSize() {
            return this.maximumSize != null ? this.maximumSize.toBuilder() : null;
        }

        public final void setMaximumSize(StorageMaximumSize.BuilderImpl maximumSize) {
            this.maximumSize = maximumSize != null ? maximumSize.build() : null;
        }

        @Override
        public final Builder maximumSize(StorageMaximumSize maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public final String getStorageLocation() {
            return this.storageLocation;
        }

        public final void setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
        }

        @Override
        public final Builder storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final StorageMinimumTimeToLive.Builder getMinimumTimeToLive() {
            return this.minimumTimeToLive != null ? this.minimumTimeToLive.toBuilder() : null;
        }

        public final void setMinimumTimeToLive(StorageMinimumTimeToLive.BuilderImpl minimumTimeToLive) {
            this.minimumTimeToLive = minimumTimeToLive != null ? minimumTimeToLive.build() : null;
        }

        @Override
        public final Builder minimumTimeToLive(StorageMinimumTimeToLive minimumTimeToLive) {
            this.minimumTimeToLive = minimumTimeToLive;
            return this;
        }

        public DataPartitionStorageOptions build() {
            return new DataPartitionStorageOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPartitionStorageOptions> {
        public Builder maximumSize(StorageMaximumSize var1);

        default public Builder maximumSize(Consumer<StorageMaximumSize.Builder> maximumSize) {
            return this.maximumSize((StorageMaximumSize)((StorageMaximumSize.Builder)StorageMaximumSize.builder().applyMutation(maximumSize)).build());
        }

        public Builder storageLocation(String var1);

        public Builder minimumTimeToLive(StorageMinimumTimeToLive var1);

        default public Builder minimumTimeToLive(Consumer<StorageMinimumTimeToLive.Builder> minimumTimeToLive) {
            return this.minimumTimeToLive((StorageMinimumTimeToLive)((StorageMinimumTimeToLive.Builder)StorageMinimumTimeToLive.builder().applyMutation(minimumTimeToLive)).build());
        }
    }
}

