/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ioteventsdata.IotEventsDataClient;
import software.amazon.awssdk.services.ioteventsdata.IotEventsDataServiceClientConfiguration;
import software.amazon.awssdk.services.ioteventsdata.internal.IotEventsDataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchAcknowledgeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDeleteDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchDisableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchEnableAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchPutMessageResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchResetAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchSnoozeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.BatchUpdateDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeAlarmResponse;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.ioteventsdata.model.InternalFailureException;
import software.amazon.awssdk.services.ioteventsdata.model.InvalidRequestException;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataException;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListAlarmsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ListDetectorsResponse;
import software.amazon.awssdk.services.ioteventsdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ioteventsdata.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ioteventsdata.model.ThrottlingException;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchAcknowledgeAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchDeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchDisableAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchEnableAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchPutMessageRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchResetAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchSnoozeAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.BatchUpdateDetectorRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.DescribeAlarmRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.DescribeDetectorRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.ListAlarmsRequestMarshaller;
import software.amazon.awssdk.services.ioteventsdata.transform.ListDetectorsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultIotEventsDataClient
implements IotEventsDataClient {
    private static final Logger log = Logger.loggerFor(DefaultIotEventsDataClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotEventsDataClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"IoT_Events_Data#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchAcknowledgeAlarmResponse batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest batchAcknowledgeAlarmRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchAcknowledgeAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchAcknowledgeAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchAcknowledgeAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchAcknowledgeAlarm");
            BatchAcknowledgeAlarmResponse batchAcknowledgeAlarmResponse = (BatchAcknowledgeAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchAcknowledgeAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchAcknowledgeAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchAcknowledgeAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchAcknowledgeAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchAcknowledgeAlarm$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteDetectorResponse batchDeleteDetector(BatchDeleteDetectorRequest batchDeleteDetectorRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchDeleteDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteDetector");
            BatchDeleteDetectorResponse batchDeleteDetectorResponse = (BatchDeleteDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchDeleteDetector$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDisableAlarmResponse batchDisableAlarm(BatchDisableAlarmRequest batchDisableAlarmRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDisableAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDisableAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchDisableAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDisableAlarm");
            BatchDisableAlarmResponse batchDisableAlarmResponse = (BatchDisableAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDisableAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDisableAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDisableAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDisableAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchDisableAlarm$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchEnableAlarmResponse batchEnableAlarm(BatchEnableAlarmRequest batchEnableAlarmRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchEnableAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchEnableAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchEnableAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchEnableAlarm");
            BatchEnableAlarmResponse batchEnableAlarmResponse = (BatchEnableAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchEnableAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchEnableAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchEnableAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchEnableAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchEnableAlarm$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutMessageResponse batchPutMessage(BatchPutMessageRequest batchPutMessageRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchPutMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchPutMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutMessage");
            BatchPutMessageResponse batchPutMessageResponse = (BatchPutMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchPutMessageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutMessageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchPutMessage$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchResetAlarmResponse batchResetAlarm(BatchResetAlarmRequest batchResetAlarmRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchResetAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchResetAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchResetAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchResetAlarm");
            BatchResetAlarmResponse batchResetAlarmResponse = (BatchResetAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchResetAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchResetAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchResetAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchResetAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchResetAlarm$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchSnoozeAlarmResponse batchSnoozeAlarm(BatchSnoozeAlarmRequest batchSnoozeAlarmRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchSnoozeAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchSnoozeAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchSnoozeAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchSnoozeAlarm");
            BatchSnoozeAlarmResponse batchSnoozeAlarmResponse = (BatchSnoozeAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchSnoozeAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchSnoozeAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchSnoozeAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchSnoozeAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchSnoozeAlarm$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateDetectorResponse batchUpdateDetector(BatchUpdateDetectorRequest batchUpdateDetectorRequest) throws InvalidRequestException, InternalFailureException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, batchUpdateDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateDetector");
            BatchUpdateDetectorResponse batchUpdateDetectorResponse = (BatchUpdateDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$batchUpdateDetector$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmResponse describeAlarm(DescribeAlarmRequest describeAlarmRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, describeAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarm");
            DescribeAlarmResponse describeAlarmResponse = (DescribeAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$describeAlarm$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, describeDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDetector");
            DescribeDetectorResponse describeDetectorResponse = (DescribeDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$describeDetector$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAlarmsResponse listAlarms(ListAlarmsRequest listAlarmsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAlarmsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAlarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, listAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAlarms");
            ListAlarmsResponse listAlarmsResponse = (ListAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAlarms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAlarmsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAlarmsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$listAlarms$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDetectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsDataClient.resolveMetricPublishers(clientConfiguration, listDetectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDetectors");
            ListDetectorsResponse listDetectorsResponse = (ListDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDetectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDetectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDetectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDetectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsDataClient.lambda$listDetectors$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ioteventsdata";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        IotEventsDataServiceClientConfigurationBuilder serviceConfigBuilder = new IotEventsDataServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IotEventsDataException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final IotEventsDataServiceClientConfiguration serviceClientConfiguration() {
        return new IotEventsDataServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$listDetectors$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAlarms$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDetector$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarm$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateDetector$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchSnoozeAlarm$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchResetAlarm$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutMessage$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchEnableAlarm$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDisableAlarm$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteDetector$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchAcknowledgeAlarm$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

