/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAlarmModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<UpdateAlarmModelRequest.Builder, UpdateAlarmModelRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(UpdateAlarmModelRequest::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelDescription").getter(getter(UpdateAlarmModelRequest::alarmModelDescription))
            .setter(setter(Builder::alarmModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateAlarmModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("severity").getter(getter(UpdateAlarmModelRequest::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<AlarmRule> ALARM_RULE_FIELD = SdkField.<AlarmRule> builder(MarshallingType.SDK_POJO)
            .memberName("alarmRule").getter(getter(UpdateAlarmModelRequest::alarmRule)).setter(setter(Builder::alarmRule))
            .constructor(AlarmRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRule").build()).build();

    private static final SdkField<AlarmNotification> ALARM_NOTIFICATION_FIELD = SdkField
            .<AlarmNotification> builder(MarshallingType.SDK_POJO).memberName("alarmNotification")
            .getter(getter(UpdateAlarmModelRequest::alarmNotification)).setter(setter(Builder::alarmNotification))
            .constructor(AlarmNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNotification").build()).build();

    private static final SdkField<AlarmEventActions> ALARM_EVENT_ACTIONS_FIELD = SdkField
            .<AlarmEventActions> builder(MarshallingType.SDK_POJO).memberName("alarmEventActions")
            .getter(getter(UpdateAlarmModelRequest::alarmEventActions)).setter(setter(Builder::alarmEventActions))
            .constructor(AlarmEventActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmEventActions").build()).build();

    private static final SdkField<AlarmCapabilities> ALARM_CAPABILITIES_FIELD = SdkField
            .<AlarmCapabilities> builder(MarshallingType.SDK_POJO).memberName("alarmCapabilities")
            .getter(getter(UpdateAlarmModelRequest::alarmCapabilities)).setter(setter(Builder::alarmCapabilities))
            .constructor(AlarmCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmCapabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, SEVERITY_FIELD, ALARM_RULE_FIELD, ALARM_NOTIFICATION_FIELD,
            ALARM_EVENT_ACTIONS_FIELD, ALARM_CAPABILITIES_FIELD));

    private final String alarmModelName;

    private final String alarmModelDescription;

    private final String roleArn;

    private final Integer severity;

    private final AlarmRule alarmRule;

    private final AlarmNotification alarmNotification;

    private final AlarmEventActions alarmEventActions;

    private final AlarmCapabilities alarmCapabilities;

    private UpdateAlarmModelRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.roleArn = builder.roleArn;
        this.severity = builder.severity;
        this.alarmRule = builder.alarmRule;
        this.alarmNotification = builder.alarmNotification;
        this.alarmEventActions = builder.alarmEventActions;
        this.alarmCapabilities = builder.alarmCapabilities;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The description of the alarm model.
     * </p>
     * 
     * @return The description of the alarm model.
     */
    public final String alarmModelDescription() {
        return alarmModelDescription;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A non-negative integer that reflects the severity level of the alarm.
     * </p>
     * 
     * @return A non-negative integer that reflects the severity level of the alarm.
     */
    public final Integer severity() {
        return severity;
    }

    /**
     * <p>
     * Defines when your alarm is invoked.
     * </p>
     * 
     * @return Defines when your alarm is invoked.
     */
    public final AlarmRule alarmRule() {
        return alarmRule;
    }

    /**
     * <p>
     * Contains information about one or more notification actions.
     * </p>
     * 
     * @return Contains information about one or more notification actions.
     */
    public final AlarmNotification alarmNotification() {
        return alarmNotification;
    }

    /**
     * <p>
     * Contains information about one or more alarm actions.
     * </p>
     * 
     * @return Contains information about one or more alarm actions.
     */
    public final AlarmEventActions alarmEventActions() {
        return alarmEventActions;
    }

    /**
     * <p>
     * Contains the configuration information of alarm state changes.
     * </p>
     * 
     * @return Contains the configuration information of alarm state changes.
     */
    public final AlarmCapabilities alarmCapabilities() {
        return alarmCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(alarmNotification());
        hashCode = 31 * hashCode + Objects.hashCode(alarmEventActions());
        hashCode = 31 * hashCode + Objects.hashCode(alarmCapabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAlarmModelRequest)) {
            return false;
        }
        UpdateAlarmModelRequest other = (UpdateAlarmModelRequest) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelDescription(), other.alarmModelDescription())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(severity(), other.severity())
                && Objects.equals(alarmRule(), other.alarmRule())
                && Objects.equals(alarmNotification(), other.alarmNotification())
                && Objects.equals(alarmEventActions(), other.alarmEventActions())
                && Objects.equals(alarmCapabilities(), other.alarmCapabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAlarmModelRequest").add("AlarmModelName", alarmModelName())
                .add("AlarmModelDescription", alarmModelDescription()).add("RoleArn", roleArn()).add("Severity", severity())
                .add("AlarmRule", alarmRule()).add("AlarmNotification", alarmNotification())
                .add("AlarmEventActions", alarmEventActions()).add("AlarmCapabilities", alarmCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelDescription":
            return Optional.ofNullable(clazz.cast(alarmModelDescription()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "alarmRule":
            return Optional.ofNullable(clazz.cast(alarmRule()));
        case "alarmNotification":
            return Optional.ofNullable(clazz.cast(alarmNotification()));
        case "alarmEventActions":
            return Optional.ofNullable(clazz.cast(alarmEventActions()));
        case "alarmCapabilities":
            return Optional.ofNullable(clazz.cast(alarmCapabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAlarmModelRequest, T> g) {
        return obj -> g.apply((UpdateAlarmModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAlarmModelRequest> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The description of the alarm model.
         * </p>
         * 
         * @param alarmModelDescription
         *        The description of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelDescription(String alarmModelDescription);

        /**
         * <p>
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A non-negative integer that reflects the severity level of the alarm.
         * </p>
         * 
         * @param severity
         *        A non-negative integer that reflects the severity level of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Integer severity);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * 
         * @param alarmRule
         *        Defines when your alarm is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRule(AlarmRule alarmRule);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmRule.Builder} avoiding the need to create
         * one manually via {@link AlarmRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmRule.Builder#build()} is called immediately and its result
         * is passed to {@link #alarmRule(AlarmRule)}.
         * 
         * @param alarmRule
         *        a consumer that will call methods on {@link AlarmRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmRule(AlarmRule)
         */
        default Builder alarmRule(Consumer<AlarmRule.Builder> alarmRule) {
            return alarmRule(AlarmRule.builder().applyMutation(alarmRule).build());
        }

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * 
         * @param alarmNotification
         *        Contains information about one or more notification actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNotification(AlarmNotification alarmNotification);

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmNotification.Builder} avoiding the need to
         * create one manually via {@link AlarmNotification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmNotification.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmNotification(AlarmNotification)}.
         * 
         * @param alarmNotification
         *        a consumer that will call methods on {@link AlarmNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmNotification(AlarmNotification)
         */
        default Builder alarmNotification(Consumer<AlarmNotification.Builder> alarmNotification) {
            return alarmNotification(AlarmNotification.builder().applyMutation(alarmNotification).build());
        }

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * 
         * @param alarmEventActions
         *        Contains information about one or more alarm actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmEventActions(AlarmEventActions alarmEventActions);

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmEventActions.Builder} avoiding the need to
         * create one manually via {@link AlarmEventActions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmEventActions.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmEventActions(AlarmEventActions)}.
         * 
         * @param alarmEventActions
         *        a consumer that will call methods on {@link AlarmEventActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmEventActions(AlarmEventActions)
         */
        default Builder alarmEventActions(Consumer<AlarmEventActions.Builder> alarmEventActions) {
            return alarmEventActions(AlarmEventActions.builder().applyMutation(alarmEventActions).build());
        }

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * 
         * @param alarmCapabilities
         *        Contains the configuration information of alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmCapabilities(AlarmCapabilities alarmCapabilities);

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmCapabilities.Builder} avoiding the need to
         * create one manually via {@link AlarmCapabilities#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmCapabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmCapabilities(AlarmCapabilities)}.
         * 
         * @param alarmCapabilities
         *        a consumer that will call methods on {@link AlarmCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmCapabilities(AlarmCapabilities)
         */
        default Builder alarmCapabilities(Consumer<AlarmCapabilities.Builder> alarmCapabilities) {
            return alarmCapabilities(AlarmCapabilities.builder().applyMutation(alarmCapabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelDescription;

        private String roleArn;

        private Integer severity;

        private AlarmRule alarmRule;

        private AlarmNotification alarmNotification;

        private AlarmEventActions alarmEventActions;

        private AlarmCapabilities alarmCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAlarmModelRequest model) {
            super(model);
            alarmModelName(model.alarmModelName);
            alarmModelDescription(model.alarmModelDescription);
            roleArn(model.roleArn);
            severity(model.severity);
            alarmRule(model.alarmRule);
            alarmNotification(model.alarmNotification);
            alarmEventActions(model.alarmEventActions);
            alarmCapabilities(model.alarmCapabilities);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        @Transient
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelDescription() {
            return alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        @Transient
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getSeverity() {
            return severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final AlarmRule.Builder getAlarmRule() {
            return alarmRule != null ? alarmRule.toBuilder() : null;
        }

        public final void setAlarmRule(AlarmRule.BuilderImpl alarmRule) {
            this.alarmRule = alarmRule != null ? alarmRule.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final AlarmNotification.Builder getAlarmNotification() {
            return alarmNotification != null ? alarmNotification.toBuilder() : null;
        }

        public final void setAlarmNotification(AlarmNotification.BuilderImpl alarmNotification) {
            this.alarmNotification = alarmNotification != null ? alarmNotification.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmNotification(AlarmNotification alarmNotification) {
            this.alarmNotification = alarmNotification;
            return this;
        }

        public final AlarmEventActions.Builder getAlarmEventActions() {
            return alarmEventActions != null ? alarmEventActions.toBuilder() : null;
        }

        public final void setAlarmEventActions(AlarmEventActions.BuilderImpl alarmEventActions) {
            this.alarmEventActions = alarmEventActions != null ? alarmEventActions.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmEventActions(AlarmEventActions alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        public final AlarmCapabilities.Builder getAlarmCapabilities() {
            return alarmCapabilities != null ? alarmCapabilities.toBuilder() : null;
        }

        public final void setAlarmCapabilities(AlarmCapabilities.BuilderImpl alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities != null ? alarmCapabilities.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmCapabilities(AlarmCapabilities alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAlarmModelRequest build() {
            return new UpdateAlarmModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
