/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDetectorModelAnalysisRequest extends IotEventsRequest implements
        ToCopyableBuilder<StartDetectorModelAnalysisRequest.Builder, StartDetectorModelAnalysisRequest> {
    private static final SdkField<DetectorModelDefinition> DETECTOR_MODEL_DEFINITION_FIELD = SdkField
            .<DetectorModelDefinition> builder(MarshallingType.SDK_POJO).memberName("detectorModelDefinition")
            .getter(getter(StartDetectorModelAnalysisRequest::detectorModelDefinition))
            .setter(setter(Builder::detectorModelDefinition)).constructor(DetectorModelDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DETECTOR_MODEL_DEFINITION_FIELD));

    private final DetectorModelDefinition detectorModelDefinition;

    private StartDetectorModelAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelDefinition = builder.detectorModelDefinition;
    }

    /**
     * Returns the value of the DetectorModelDefinition property for this object.
     * 
     * @return The value of the DetectorModelDefinition property for this object.
     */
    public final DetectorModelDefinition detectorModelDefinition() {
        return detectorModelDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDetectorModelAnalysisRequest)) {
            return false;
        }
        StartDetectorModelAnalysisRequest other = (StartDetectorModelAnalysisRequest) obj;
        return Objects.equals(detectorModelDefinition(), other.detectorModelDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDetectorModelAnalysisRequest").add("DetectorModelDefinition", detectorModelDefinition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelDefinition":
            return Optional.ofNullable(clazz.cast(detectorModelDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDetectorModelAnalysisRequest, T> g) {
        return obj -> g.apply((StartDetectorModelAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDetectorModelAnalysisRequest> {
        /**
         * Sets the value of the DetectorModelDefinition property for this object.
         *
         * @param detectorModelDefinition
         *        The new value for the DetectorModelDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition);

        /**
         * Sets the value of the DetectorModelDefinition property for this object.
         *
         * This is a convenience that creates an instance of the {@link DetectorModelDefinition.Builder} avoiding the
         * need to create one manually via {@link DetectorModelDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectorModelDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #detectorModelDefinition(DetectorModelDefinition)}.
         * 
         * @param detectorModelDefinition
         *        a consumer that will call methods on {@link DetectorModelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModelDefinition(DetectorModelDefinition)
         */
        default Builder detectorModelDefinition(Consumer<DetectorModelDefinition.Builder> detectorModelDefinition) {
            return detectorModelDefinition(DetectorModelDefinition.builder().applyMutation(detectorModelDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private DetectorModelDefinition detectorModelDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDetectorModelAnalysisRequest model) {
            super(model);
            detectorModelDefinition(model.detectorModelDefinition);
        }

        public final DetectorModelDefinition.Builder getDetectorModelDefinition() {
            return detectorModelDefinition != null ? detectorModelDefinition.toBuilder() : null;
        }

        public final void setDetectorModelDefinition(DetectorModelDefinition.BuilderImpl detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition != null ? detectorModelDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDetectorModelAnalysisRequest build() {
            return new StartDetectorModelAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
