/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to configure the payload.
 * </p>
 * <p>
 * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all
 * attribute-value pairs that have the information about the detector model instance and the event triggered the action.
 * To configure the action payload, you can use <code>contentExpression</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Payload implements SdkPojo, Serializable, ToCopyableBuilder<Payload.Builder, Payload> {
    private static final SdkField<String> CONTENT_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentExpression").getter(getter(Payload::contentExpression))
            .setter(setter(Builder::contentExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentExpression").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Payload::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_EXPRESSION_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contentExpression;

    private final String type;

    private Payload(BuilderImpl builder) {
        this.contentExpression = builder.contentExpression;
        this.type = builder.type;
    }

    /**
     * <p>
     * The content of the payload. You can use a string expression that includes quoted strings (
     * <code>'&lt;string&gt;'</code>), variables (<code>$variable.&lt;variable-name&gt;</code>), input values (
     * <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>), string concatenations, and quoted strings that
     * contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
     * </p>
     * 
     * @return The content of the payload. You can use a string expression that includes quoted strings (
     *         <code>'&lt;string&gt;'</code>), variables (<code>$variable.&lt;variable-name&gt;</code>), input values (
     *         <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>), string concatenations, and quoted strings
     *         that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1
     *         KB.
     */
    public final String contentExpression() {
        return contentExpression;
    }

    /**
     * <p>
     * The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
     * @see PayloadType
     */
    public final PayloadType type() {
        return PayloadType.fromValue(type);
    }

    /**
     * <p>
     * The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
     * @see PayloadType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentExpression());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payload)) {
            return false;
        }
        Payload other = (Payload) obj;
        return Objects.equals(contentExpression(), other.contentExpression())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Payload").add("ContentExpression", contentExpression()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentExpression":
            return Optional.ofNullable(clazz.cast(contentExpression()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Payload, T> g) {
        return obj -> g.apply((Payload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Payload> {
        /**
         * <p>
         * The content of the payload. You can use a string expression that includes quoted strings (
         * <code>'&lt;string&gt;'</code>), variables (<code>$variable.&lt;variable-name&gt;</code>), input values (
         * <code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>), string concatenations, and quoted strings that
         * contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.
         * </p>
         * 
         * @param contentExpression
         *        The content of the payload. You can use a string expression that includes quoted strings (
         *        <code>'&lt;string&gt;'</code>), variables (<code>$variable.&lt;variable-name&gt;</code>), input values
         *        (<code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>), string concatenations, and quoted
         *        strings that contain <code>${}</code> as the content. The recommended maximum size of a content
         *        expression is 1 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentExpression(String contentExpression);

        /**
         * <p>
         * The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
         * </p>
         * 
         * @param type
         *        The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(String type);

        /**
         * <p>
         * The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
         * </p>
         * 
         * @param type
         *        The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(PayloadType type);
    }

    static final class BuilderImpl implements Builder {
        private String contentExpression;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Payload model) {
            contentExpression(model.contentExpression);
            type(model.type);
        }

        public final String getContentExpression() {
            return contentExpression;
        }

        public final void setContentExpression(String contentExpression) {
            this.contentExpression = contentExpression;
        }

        @Override
        @Transient
        public final Builder contentExpression(String contentExpression) {
            this.contentExpression = contentExpression;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(PayloadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Payload build() {
            return new Payload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
