/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnEnterLifecycle implements SdkPojo, Serializable,
        ToCopyableBuilder<OnEnterLifecycle.Builder, OnEnterLifecycle> {
    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(OnEnterLifecycle::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Event> events;

    private OnEnterLifecycle(BuilderImpl builder) {
        this.events = builder.events;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the actions that are performed when the state is entered and the <code>condition</code> is
     * <code>TRUE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return Specifies the actions that are performed when the state is entered and the <code>condition</code> is
     *         <code>TRUE</code>.
     */
    public final List<Event> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnEnterLifecycle)) {
            return false;
        }
        OnEnterLifecycle other = (OnEnterLifecycle) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnEnterLifecycle").add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnEnterLifecycle, T> g) {
        return obj -> g.apply((OnEnterLifecycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnEnterLifecycle> {
        /**
         * <p>
         * Specifies the actions that are performed when the state is entered and the <code>condition</code> is
         * <code>TRUE</code>.
         * </p>
         * 
         * @param events
         *        Specifies the actions that are performed when the state is entered and the <code>condition</code> is
         *        <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * <p>
         * Specifies the actions that are performed when the state is entered and the <code>condition</code> is
         * <code>TRUE</code>.
         * </p>
         * 
         * @param events
         *        Specifies the actions that are performed when the state is entered and the <code>condition</code> is
         *        <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * Specifies the actions that are performed when the state is entered and the <code>condition</code> is
         * <code>TRUE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Event>.Builder} avoiding the need to create
         * one manually via {@link List<Event>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Event>.Builder#build()} is called immediately and its result
         * is passed to {@link #events(List<Event>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<Event>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<Event>)
         */
        Builder events(Consumer<Event.Builder>... events);
    }

    static final class BuilderImpl implements Builder {
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnEnterLifecycle model) {
            events(model.events);
        }

        public final List<Event.Builder> getEvents() {
            List<Event.Builder> result = EventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventsCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<Event> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder>... events) {
            events(Stream.of(events).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OnEnterLifecycle build() {
            return new OnEnterLifecycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
