/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifer of the input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputIdentifier implements SdkPojo, Serializable, ToCopyableBuilder<InputIdentifier.Builder, InputIdentifier> {
    private static final SdkField<IotEventsInputIdentifier> IOT_EVENTS_INPUT_IDENTIFIER_FIELD = SdkField
            .<IotEventsInputIdentifier> builder(MarshallingType.SDK_POJO).memberName("iotEventsInputIdentifier")
            .getter(getter(InputIdentifier::iotEventsInputIdentifier)).setter(setter(Builder::iotEventsInputIdentifier))
            .constructor(IotEventsInputIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEventsInputIdentifier").build())
            .build();

    private static final SdkField<IotSiteWiseInputIdentifier> IOT_SITE_WISE_INPUT_IDENTIFIER_FIELD = SdkField
            .<IotSiteWiseInputIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("iotSiteWiseInputIdentifier")
            .getter(getter(InputIdentifier::iotSiteWiseInputIdentifier))
            .setter(setter(Builder::iotSiteWiseInputIdentifier))
            .constructor(IotSiteWiseInputIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseInputIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IOT_EVENTS_INPUT_IDENTIFIER_FIELD, IOT_SITE_WISE_INPUT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final IotEventsInputIdentifier iotEventsInputIdentifier;

    private final IotSiteWiseInputIdentifier iotSiteWiseInputIdentifier;

    private InputIdentifier(BuilderImpl builder) {
        this.iotEventsInputIdentifier = builder.iotEventsInputIdentifier;
        this.iotSiteWiseInputIdentifier = builder.iotSiteWiseInputIdentifier;
    }

    /**
     * <p>
     * The identifier of the input routed to AWS IoT Events.
     * </p>
     * 
     * @return The identifier of the input routed to AWS IoT Events.
     */
    public final IotEventsInputIdentifier iotEventsInputIdentifier() {
        return iotEventsInputIdentifier;
    }

    /**
     * <p>
     * The identifer of the input routed from AWS IoT SiteWise.
     * </p>
     * 
     * @return The identifer of the input routed from AWS IoT SiteWise.
     */
    public final IotSiteWiseInputIdentifier iotSiteWiseInputIdentifier() {
        return iotSiteWiseInputIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iotEventsInputIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseInputIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputIdentifier)) {
            return false;
        }
        InputIdentifier other = (InputIdentifier) obj;
        return Objects.equals(iotEventsInputIdentifier(), other.iotEventsInputIdentifier())
                && Objects.equals(iotSiteWiseInputIdentifier(), other.iotSiteWiseInputIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputIdentifier").add("IotEventsInputIdentifier", iotEventsInputIdentifier())
                .add("IotSiteWiseInputIdentifier", iotSiteWiseInputIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iotEventsInputIdentifier":
            return Optional.ofNullable(clazz.cast(iotEventsInputIdentifier()));
        case "iotSiteWiseInputIdentifier":
            return Optional.ofNullable(clazz.cast(iotSiteWiseInputIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputIdentifier, T> g) {
        return obj -> g.apply((InputIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputIdentifier> {
        /**
         * <p>
         * The identifier of the input routed to AWS IoT Events.
         * </p>
         * 
         * @param iotEventsInputIdentifier
         *        The identifier of the input routed to AWS IoT Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotEventsInputIdentifier(IotEventsInputIdentifier iotEventsInputIdentifier);

        /**
         * <p>
         * The identifier of the input routed to AWS IoT Events.
         * </p>
         * This is a convenience that creates an instance of the {@link IotEventsInputIdentifier.Builder} avoiding the
         * need to create one manually via {@link IotEventsInputIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotEventsInputIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #iotEventsInputIdentifier(IotEventsInputIdentifier)}.
         * 
         * @param iotEventsInputIdentifier
         *        a consumer that will call methods on {@link IotEventsInputIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotEventsInputIdentifier(IotEventsInputIdentifier)
         */
        default Builder iotEventsInputIdentifier(Consumer<IotEventsInputIdentifier.Builder> iotEventsInputIdentifier) {
            return iotEventsInputIdentifier(IotEventsInputIdentifier.builder().applyMutation(iotEventsInputIdentifier).build());
        }

        /**
         * <p>
         * The identifer of the input routed from AWS IoT SiteWise.
         * </p>
         * 
         * @param iotSiteWiseInputIdentifier
         *        The identifer of the input routed from AWS IoT SiteWise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier iotSiteWiseInputIdentifier);

        /**
         * <p>
         * The identifer of the input routed from AWS IoT SiteWise.
         * </p>
         * This is a convenience that creates an instance of the {@link IotSiteWiseInputIdentifier.Builder} avoiding the
         * need to create one manually via {@link IotSiteWiseInputIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotSiteWiseInputIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #iotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier)}.
         * 
         * @param iotSiteWiseInputIdentifier
         *        a consumer that will call methods on {@link IotSiteWiseInputIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier)
         */
        default Builder iotSiteWiseInputIdentifier(Consumer<IotSiteWiseInputIdentifier.Builder> iotSiteWiseInputIdentifier) {
            return iotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier.builder().applyMutation(iotSiteWiseInputIdentifier)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IotEventsInputIdentifier iotEventsInputIdentifier;

        private IotSiteWiseInputIdentifier iotSiteWiseInputIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InputIdentifier model) {
            iotEventsInputIdentifier(model.iotEventsInputIdentifier);
            iotSiteWiseInputIdentifier(model.iotSiteWiseInputIdentifier);
        }

        public final IotEventsInputIdentifier.Builder getIotEventsInputIdentifier() {
            return iotEventsInputIdentifier != null ? iotEventsInputIdentifier.toBuilder() : null;
        }

        public final void setIotEventsInputIdentifier(IotEventsInputIdentifier.BuilderImpl iotEventsInputIdentifier) {
            this.iotEventsInputIdentifier = iotEventsInputIdentifier != null ? iotEventsInputIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder iotEventsInputIdentifier(IotEventsInputIdentifier iotEventsInputIdentifier) {
            this.iotEventsInputIdentifier = iotEventsInputIdentifier;
            return this;
        }

        public final IotSiteWiseInputIdentifier.Builder getIotSiteWiseInputIdentifier() {
            return iotSiteWiseInputIdentifier != null ? iotSiteWiseInputIdentifier.toBuilder() : null;
        }

        public final void setIotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier.BuilderImpl iotSiteWiseInputIdentifier) {
            this.iotSiteWiseInputIdentifier = iotSiteWiseInputIdentifier != null ? iotSiteWiseInputIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder iotSiteWiseInputIdentifier(IotSiteWiseInputIdentifier iotSiteWiseInputIdentifier) {
            this.iotSiteWiseInputIdentifier = iotSiteWiseInputIdentifier;
            return this;
        }

        @Override
        public InputIdentifier build() {
            return new InputIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
