/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the configuration of an input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfiguration.Builder, InputConfiguration> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(InputConfiguration::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputDescription").getter(getter(InputConfiguration::inputDescription))
            .setter(setter(Builder::inputDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()).build();

    private static final SdkField<String> INPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputArn").getter(getter(InputConfiguration::inputArn)).setter(setter(Builder::inputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(InputConfiguration::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(InputConfiguration::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(InputConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            INPUT_DESCRIPTION_FIELD, INPUT_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final String inputDescription;

    private final String inputArn;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String status;

    private InputConfiguration(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputArn = builder.inputArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the input.
     * </p>
     * 
     * @return The name of the input.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * A brief description of the input.
     * </p>
     * 
     * @return A brief description of the input.
     */
    public final String inputDescription() {
        return inputDescription;
    }

    /**
     * <p>
     * The ARN of the input.
     * </p>
     * 
     * @return The ARN of the input.
     */
    public final String inputArn() {
        return inputArn;
    }

    /**
     * <p>
     * The time the input was created.
     * </p>
     * 
     * @return The time the input was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the input was updated.
     * </p>
     * 
     * @return The last time the input was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the input.
     * @see InputStatus
     */
    public final InputStatus status() {
        return InputStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the input.
     * @see InputStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inputArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(inputDescription(), other.inputDescription())
                && Objects.equals(inputArn(), other.inputArn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfiguration").add("InputName", inputName()).add("InputDescription", inputDescription())
                .add("InputArn", inputArn()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "inputDescription":
            return Optional.ofNullable(clazz.cast(inputDescription()));
        case "inputArn":
            return Optional.ofNullable(clazz.cast(inputArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfiguration, T> g) {
        return obj -> g.apply((InputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfiguration> {
        /**
         * <p>
         * The name of the input.
         * </p>
         * 
         * @param inputName
         *        The name of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * A brief description of the input.
         * </p>
         * 
         * @param inputDescription
         *        A brief description of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescription(String inputDescription);

        /**
         * <p>
         * The ARN of the input.
         * </p>
         * 
         * @param inputArn
         *        The ARN of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArn(String inputArn);

        /**
         * <p>
         * The time the input was created.
         * </p>
         * 
         * @param creationTime
         *        The time the input was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the input was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the input was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the input.
         * </p>
         * 
         * @param status
         *        The status of the input.
         * @see InputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the input.
         * </p>
         * 
         * @param status
         *        The status of the input.
         * @see InputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStatus
         */
        Builder status(InputStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private String inputDescription;

        private String inputArn;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            inputName(model.inputName);
            inputDescription(model.inputDescription);
            inputArn(model.inputArn);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        @Transient
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getInputDescription() {
            return inputDescription;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        @Override
        @Transient
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final String getInputArn() {
            return inputArn;
        }

        public final void setInputArn(String inputArn) {
            this.inputArn = inputArn;
        }

        @Override
        @Transient
        public final Builder inputArn(String inputArn) {
            this.inputArn = inputArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InputStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public InputConfiguration build() {
            return new InputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
