/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data
 * Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirehoseAction implements SdkPojo, Serializable, ToCopyableBuilder<FirehoseAction.Builder, FirehoseAction> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryStreamName").getter(getter(FirehoseAction::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStreamName").build())
            .build();

    private static final SdkField<String> SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("separator").getter(getter(FirehoseAction::separator)).setter(setter(Builder::separator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("separator").build()).build();

    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.<Payload> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(FirehoseAction::payload)).setter(setter(Builder::payload))
            .constructor(Payload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            SEPARATOR_FIELD, PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deliveryStreamName;

    private final String separator;

    private final Payload payload;

    private FirehoseAction(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the Kinesis Data Firehose delivery stream where the data is written.
     * </p>
     * 
     * @return The name of the Kinesis Data Firehose delivery stream where the data is written.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
     * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     * </p>
     * 
     * @return A character separator that is used to separate records written to the Kinesis Data Firehose delivery
     *         stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public final String separator() {
        return separator;
    }

    /**
     * <p>
     * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @return You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery
     *         stream.
     */
    public final Payload payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(separator());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(separator(), other.separator())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirehoseAction").add("DeliveryStreamName", deliveryStreamName()).add("Separator", separator())
                .add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "separator":
            return Optional.ofNullable(clazz.cast(separator()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirehoseAction, T> g) {
        return obj -> g.apply((FirehoseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirehoseAction> {
        /**
         * <p>
         * The name of the Kinesis Data Firehose delivery stream where the data is written.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the Kinesis Data Firehose delivery stream where the data is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream.
         * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * </p>
         * 
         * @param separator
         *        A character separator that is used to separate records written to the Kinesis Data Firehose delivery
         *        stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separator(String separator);

        /**
         * <p>
         * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery
         * stream.
         * </p>
         * 
         * @param payload
         *        You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose
         *        delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Payload payload);

        /**
         * <p>
         * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery
         * stream.
         * </p>
         * This is a convenience that creates an instance of the {@link Payload.Builder} avoiding the need to create one
         * manually via {@link Payload#builder()}.
         *
         * When the {@link Consumer} completes, {@link Payload.Builder#build()} is called immediately and its result is
         * passed to {@link #payload(Payload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Payload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Payload)
         */
        default Builder payload(Consumer<Payload.Builder> payload) {
            return payload(Payload.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String separator;

        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            deliveryStreamName(model.deliveryStreamName);
            separator(model.separator);
            payload(model.payload);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        @Transient
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getSeparator() {
            return separator;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        @Transient
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final Payload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        @Transient
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public FirehoseAction build() {
            return new FirehoseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
