/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the subject and message of an email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailContent implements SdkPojo, Serializable, ToCopyableBuilder<EmailContent.Builder, EmailContent> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(EmailContent::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> ADDITIONAL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalMessage").getter(getter(EmailContent::additionalMessage))
            .setter(setter(Builder::additionalMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD,
            ADDITIONAL_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subject;

    private final String additionalMessage;

    private EmailContent(BuilderImpl builder) {
        this.subject = builder.subject;
        this.additionalMessage = builder.additionalMessage;
    }

    /**
     * <p>
     * The subject of the email.
     * </p>
     * 
     * @return The subject of the email.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     * 
     * @return The message that you want to send. The message can be up to 200 characters.
     */
    public final String additionalMessage() {
        return additionalMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailContent)) {
            return false;
        }
        EmailContent other = (EmailContent) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(additionalMessage(), other.additionalMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailContent").add("Subject", subject()).add("AdditionalMessage", additionalMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "additionalMessage":
            return Optional.ofNullable(clazz.cast(additionalMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailContent, T> g) {
        return obj -> g.apply((EmailContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailContent> {
        /**
         * <p>
         * The subject of the email.
         * </p>
         * 
         * @param subject
         *        The subject of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The message that you want to send. The message can be up to 200 characters.
         * </p>
         * 
         * @param additionalMessage
         *        The message that you want to send. The message can be up to 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMessage(String additionalMessage);
    }

    static final class BuilderImpl implements Builder {
        private String subject;

        private String additionalMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailContent model) {
            subject(model.subject);
            additionalMessage(model.additionalMessage);
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        @Transient
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getAdditionalMessage() {
            return additionalMessage;
        }

        public final void setAdditionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
        }

        @Override
        @Transient
        public final Builder additionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
            return this;
        }

        @Override
        public EmailContent build() {
            return new EmailContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
