/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the detector model version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorModelVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorModelVersionSummary.Builder, DetectorModelVersionSummary> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(DetectorModelVersionSummary::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelVersion").getter(getter(DetectorModelVersionSummary::detectorModelVersion))
            .setter(setter(Builder::detectorModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build())
            .build();

    private static final SdkField<String> DETECTOR_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelArn").getter(getter(DetectorModelVersionSummary::detectorModelArn))
            .setter(setter(Builder::detectorModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DetectorModelVersionSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DetectorModelVersionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(DetectorModelVersionSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DetectorModelVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> EVALUATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationMethod").getter(getter(DetectorModelVersionSummary::evaluationMethodAsString))
            .setter(setter(Builder::evaluationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            DETECTOR_MODEL_VERSION_FIELD, DETECTOR_MODEL_ARN_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD,
            STATUS_FIELD, EVALUATION_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorModelName;

    private final String detectorModelVersion;

    private final String detectorModelArn;

    private final String roleArn;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String status;

    private final String evaluationMethod;

    private DetectorModelVersionSummary(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.detectorModelArn = builder.detectorModelArn;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.evaluationMethod = builder.evaluationMethod;
    }

    /**
     * <p>
     * The name of the detector model.
     * </p>
     * 
     * @return The name of the detector model.
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The ID of the detector model version.
     * </p>
     * 
     * @return The ID of the detector model version.
     */
    public final String detectorModelVersion() {
        return detectorModelVersion;
    }

    /**
     * <p>
     * The ARN of the detector model version.
     * </p>
     * 
     * @return The ARN of the detector model version.
     */
    public final String detectorModelArn() {
        return detectorModelArn;
    }

    /**
     * <p>
     * The ARN of the role that grants the detector model permission to perform its tasks.
     * </p>
     * 
     * @return The ARN of the role that grants the detector model permission to perform its tasks.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The time the detector model version was created.
     * </p>
     * 
     * @return The time the detector model version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the detector model version was updated.
     * </p>
     * 
     * @return The last time the detector model version was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the detector model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector model version.
     * @see DetectorModelVersionStatus
     */
    public final DetectorModelVersionStatus status() {
        return DetectorModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the detector model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector model version.
     * @see DetectorModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the order in which events are evaluated and how actions are executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMethod}
     * will return {@link EvaluationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationMethodAsString}.
     * </p>
     * 
     * @return Information about the order in which events are evaluated and how actions are executed.
     * @see EvaluationMethod
     */
    public final EvaluationMethod evaluationMethod() {
        return EvaluationMethod.fromValue(evaluationMethod);
    }

    /**
     * <p>
     * Information about the order in which events are evaluated and how actions are executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMethod}
     * will return {@link EvaluationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationMethodAsString}.
     * </p>
     * 
     * @return Information about the order in which events are evaluated and how actions are executed.
     * @see EvaluationMethod
     */
    public final String evaluationMethodAsString() {
        return evaluationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelVersionSummary)) {
            return false;
        }
        DetectorModelVersionSummary other = (DetectorModelVersionSummary) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(detectorModelVersion(), other.detectorModelVersion())
                && Objects.equals(detectorModelArn(), other.detectorModelArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(evaluationMethodAsString(), other.evaluationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorModelVersionSummary").add("DetectorModelName", detectorModelName())
                .add("DetectorModelVersion", detectorModelVersion()).add("DetectorModelArn", detectorModelArn())
                .add("RoleArn", roleArn()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("Status", statusAsString()).add("EvaluationMethod", evaluationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "detectorModelVersion":
            return Optional.ofNullable(clazz.cast(detectorModelVersion()));
        case "detectorModelArn":
            return Optional.ofNullable(clazz.cast(detectorModelArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "evaluationMethod":
            return Optional.ofNullable(clazz.cast(evaluationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelVersionSummary, T> g) {
        return obj -> g.apply((DetectorModelVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorModelVersionSummary> {
        /**
         * <p>
         * The name of the detector model.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The ID of the detector model version.
         * </p>
         * 
         * @param detectorModelVersion
         *        The ID of the detector model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelVersion(String detectorModelVersion);

        /**
         * <p>
         * The ARN of the detector model version.
         * </p>
         * 
         * @param detectorModelArn
         *        The ARN of the detector model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelArn(String detectorModelArn);

        /**
         * <p>
         * The ARN of the role that grants the detector model permission to perform its tasks.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants the detector model permission to perform its tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The time the detector model version was created.
         * </p>
         * 
         * @param creationTime
         *        The time the detector model version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the detector model version was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the detector model version was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the detector model version.
         * </p>
         * 
         * @param status
         *        The status of the detector model version.
         * @see DetectorModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the detector model version.
         * </p>
         * 
         * @param status
         *        The status of the detector model version.
         * @see DetectorModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorModelVersionStatus
         */
        Builder status(DetectorModelVersionStatus status);

        /**
         * <p>
         * Information about the order in which events are evaluated and how actions are executed.
         * </p>
         * 
         * @param evaluationMethod
         *        Information about the order in which events are evaluated and how actions are executed.
         * @see EvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMethod
         */
        Builder evaluationMethod(String evaluationMethod);

        /**
         * <p>
         * Information about the order in which events are evaluated and how actions are executed.
         * </p>
         * 
         * @param evaluationMethod
         *        Information about the order in which events are evaluated and how actions are executed.
         * @see EvaluationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMethod
         */
        Builder evaluationMethod(EvaluationMethod evaluationMethod);
    }

    static final class BuilderImpl implements Builder {
        private String detectorModelName;

        private String detectorModelVersion;

        private String detectorModelArn;

        private String roleArn;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String status;

        private String evaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelVersionSummary model) {
            detectorModelName(model.detectorModelName);
            detectorModelVersion(model.detectorModelVersion);
            detectorModelArn(model.detectorModelArn);
            roleArn(model.roleArn);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
            evaluationMethod(model.evaluationMethod);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        @Transient
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getDetectorModelVersion() {
            return detectorModelVersion;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        @Transient
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final String getDetectorModelArn() {
            return detectorModelArn;
        }

        public final void setDetectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
        }

        @Override
        @Transient
        public final Builder detectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DetectorModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEvaluationMethod() {
            return evaluationMethod;
        }

        public final void setEvaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
        }

        @Override
        @Transient
        public final Builder evaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder evaluationMethod(EvaluationMethod evaluationMethod) {
            this.evaluationMethod(evaluationMethod == null ? null : evaluationMethod.toString());
            return this;
        }

        @Override
        public DetectorModelVersionSummary build() {
            return new DetectorModelVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
