/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the detector model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorModelSummary.Builder, DetectorModelSummary> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(DetectorModelSummary::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelDescription").getter(getter(DetectorModelSummary::detectorModelDescription))
            .setter(setter(Builder::detectorModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DetectorModelSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD,
            DETECTOR_MODEL_DESCRIPTION_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorModelName;

    private final String detectorModelDescription;

    private final Instant creationTime;

    private DetectorModelSummary(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the detector model.
     * </p>
     * 
     * @return The name of the detector model.
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * A brief description of the detector model.
     * </p>
     * 
     * @return A brief description of the detector model.
     */
    public final String detectorModelDescription() {
        return detectorModelDescription;
    }

    /**
     * <p>
     * The time the detector model was created.
     * </p>
     * 
     * @return The time the detector model was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelSummary)) {
            return false;
        }
        DetectorModelSummary other = (DetectorModelSummary) obj;
        return Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(detectorModelDescription(), other.detectorModelDescription())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorModelSummary").add("DetectorModelName", detectorModelName())
                .add("DetectorModelDescription", detectorModelDescription()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "detectorModelDescription":
            return Optional.ofNullable(clazz.cast(detectorModelDescription()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelSummary, T> g) {
        return obj -> g.apply((DetectorModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorModelSummary> {
        /**
         * <p>
         * The name of the detector model.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * A brief description of the detector model.
         * </p>
         * 
         * @param detectorModelDescription
         *        A brief description of the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelDescription(String detectorModelDescription);

        /**
         * <p>
         * The time the detector model was created.
         * </p>
         * 
         * @param creationTime
         *        The time the detector model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String detectorModelName;

        private String detectorModelDescription;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelSummary model) {
            detectorModelName(model.detectorModelName);
            detectorModelDescription(model.detectorModelDescription);
            creationTime(model.creationTime);
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        @Transient
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getDetectorModelDescription() {
            return detectorModelDescription;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        @Override
        @Transient
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DetectorModelSummary build() {
            return new DetectorModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
