/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that defines how a detector operates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorModelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorModelDefinition.Builder, DetectorModelDefinition> {
    private static final SdkField<List<State>> STATES_FIELD = SdkField
            .<List<State>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(DetectorModelDefinition::states))
            .setter(setter(Builder::states))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<State> builder(MarshallingType.SDK_POJO)
                                            .constructor(State::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INITIAL_STATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("initialStateName").getter(getter(DetectorModelDefinition::initialStateName))
            .setter(setter(Builder::initialStateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialStateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATES_FIELD,
            INITIAL_STATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<State> states;

    private final String initialStateName;

    private DetectorModelDefinition(BuilderImpl builder) {
        this.states = builder.states;
        this.initialStateName = builder.initialStateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the states of the detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return Information about the states of the detector.
     */
    public final List<State> states() {
        return states;
    }

    /**
     * <p>
     * The state that is entered at the creation of each detector (instance).
     * </p>
     * 
     * @return The state that is entered at the creation of each detector (instance).
     */
    public final String initialStateName() {
        return initialStateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? states() : null);
        hashCode = 31 * hashCode + Objects.hashCode(initialStateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelDefinition)) {
            return false;
        }
        DetectorModelDefinition other = (DetectorModelDefinition) obj;
        return hasStates() == other.hasStates() && Objects.equals(states(), other.states())
                && Objects.equals(initialStateName(), other.initialStateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorModelDefinition").add("States", hasStates() ? states() : null)
                .add("InitialStateName", initialStateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "states":
            return Optional.ofNullable(clazz.cast(states()));
        case "initialStateName":
            return Optional.ofNullable(clazz.cast(initialStateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelDefinition, T> g) {
        return obj -> g.apply((DetectorModelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorModelDefinition> {
        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * 
         * @param states
         *        Information about the states of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<State> states);

        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * 
         * @param states
         *        Information about the states of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(State... states);

        /**
         * <p>
         * Information about the states of the detector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<State>.Builder} avoiding the need to create
         * one manually via {@link List<State>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<State>.Builder#build()} is called immediately and its result
         * is passed to {@link #states(List<State>)}.
         * 
         * @param states
         *        a consumer that will call methods on {@link List<State>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #states(List<State>)
         */
        Builder states(Consumer<State.Builder>... states);

        /**
         * <p>
         * The state that is entered at the creation of each detector (instance).
         * </p>
         * 
         * @param initialStateName
         *        The state that is entered at the creation of each detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialStateName(String initialStateName);
    }

    static final class BuilderImpl implements Builder {
        private List<State> states = DefaultSdkAutoConstructList.getInstance();

        private String initialStateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelDefinition model) {
            states(model.states);
            initialStateName(model.initialStateName);
        }

        public final List<State.Builder> getStates() {
            List<State.Builder> result = StatesCopier.copyToBuilder(this.states);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStates(Collection<State.BuilderImpl> states) {
            this.states = StatesCopier.copyFromBuilder(states);
        }

        @Override
        @Transient
        public final Builder states(Collection<State> states) {
            this.states = StatesCopier.copy(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder states(State... states) {
            states(Arrays.asList(states));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder states(Consumer<State.Builder>... states) {
            states(Stream.of(states).map(c -> State.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInitialStateName() {
            return initialStateName;
        }

        public final void setInitialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
        }

        @Override
        @Transient
        public final Builder initialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
            return this;
        }

        @Override
        public DetectorModelDefinition build() {
            return new DetectorModelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
