/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorModelResponse extends IotEventsResponse implements
        ToCopyableBuilder<DescribeDetectorModelResponse.Builder, DescribeDetectorModelResponse> {
    private static final SdkField<DetectorModel> DETECTOR_MODEL_FIELD = SdkField
            .<DetectorModel> builder(MarshallingType.SDK_POJO).memberName("detectorModel")
            .getter(getter(DescribeDetectorModelResponse::detectorModel)).setter(setter(Builder::detectorModel))
            .constructor(DetectorModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_FIELD));

    private final DetectorModel detectorModel;

    private DescribeDetectorModelResponse(BuilderImpl builder) {
        super(builder);
        this.detectorModel = builder.detectorModel;
    }

    /**
     * <p>
     * Information about the detector model.
     * </p>
     * 
     * @return Information about the detector model.
     */
    public final DetectorModel detectorModel() {
        return detectorModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorModelResponse)) {
            return false;
        }
        DescribeDetectorModelResponse other = (DescribeDetectorModelResponse) obj;
        return Objects.equals(detectorModel(), other.detectorModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectorModelResponse").add("DetectorModel", detectorModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorModel":
            return Optional.ofNullable(clazz.cast(detectorModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorModelResponse, T> g) {
        return obj -> g.apply((DescribeDetectorModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDetectorModelResponse> {
        /**
         * <p>
         * Information about the detector model.
         * </p>
         * 
         * @param detectorModel
         *        Information about the detector model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModel(DetectorModel detectorModel);

        /**
         * <p>
         * Information about the detector model.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectorModel.Builder} avoiding the need to
         * create one manually via {@link DetectorModel#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectorModel.Builder#build()} is called immediately and its
         * result is passed to {@link #detectorModel(DetectorModel)}.
         * 
         * @param detectorModel
         *        a consumer that will call methods on {@link DetectorModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorModel(DetectorModel)
         */
        default Builder detectorModel(Consumer<DetectorModel.Builder> detectorModel) {
            return detectorModel(DetectorModel.builder().applyMutation(detectorModel).build());
        }
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private DetectorModel detectorModel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorModelResponse model) {
            super(model);
            detectorModel(model.detectorModel);
        }

        public final DetectorModel.Builder getDetectorModel() {
            return detectorModel != null ? detectorModel.toBuilder() : null;
        }

        public final void setDetectorModel(DetectorModel.BuilderImpl detectorModel) {
            this.detectorModel = detectorModel != null ? detectorModel.build() : null;
        }

        @Override
        @Transient
        public final Builder detectorModel(DetectorModel detectorModel) {
            this.detectorModel = detectorModel;
            return this;
        }

        @Override
        public DescribeDetectorModelResponse build() {
            return new DescribeDetectorModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
