/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of an alarm model version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmModelVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmModelVersionSummary.Builder, AlarmModelVersionSummary> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(AlarmModelVersionSummary::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelArn").getter(getter(AlarmModelVersionSummary::alarmModelArn))
            .setter(setter(Builder::alarmModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelArn").build()).build();

    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelVersion").getter(getter(AlarmModelVersionSummary::alarmModelVersion))
            .setter(setter(Builder::alarmModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AlarmModelVersionSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AlarmModelVersionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(AlarmModelVersionSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AlarmModelVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(AlarmModelVersionSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_ARN_FIELD, ALARM_MODEL_VERSION_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmModelName;

    private final String alarmModelArn;

    private final String alarmModelVersion;

    private final String roleArn;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String status;

    private final String statusMessage;

    private AlarmModelVersionSummary(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelArn = builder.alarmModelArn;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The ARN of the alarm model. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the alarm model. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String alarmModelArn() {
        return alarmModelArn;
    }

    /**
     * <p>
     * The version of the alarm model.
     * </p>
     * 
     * @return The version of the alarm model.
     */
    public final String alarmModelVersion() {
        return alarmModelVersion;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The time the alarm model was created, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm model was created, in the Unix epoch format.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the alarm model was last updated, in the Unix epoch format.
     * </p>
     * 
     * @return The time the alarm model was last updated, in the Unix epoch format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The status of the alarm model. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to
     * a few minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model
     * information and update the alarm model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AlarmModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the alarm model. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
     *         take up to a few minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
     *         model information and update the alarm model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
     *         and try again.
     *         </p>
     *         </li>
     * @see AlarmModelVersionStatus
     */
    public final AlarmModelVersionStatus status() {
        return AlarmModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the alarm model. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to
     * a few minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model
     * information and update the alarm model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and try
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AlarmModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the alarm model. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
     *         take up to a few minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
     *         model information and update the alarm model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information
     *         and try again.
     *         </p>
     *         </li>
     * @see AlarmModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains information about the status of the alarm model version.
     * </p>
     * 
     * @return Contains information about the status of the alarm model version.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmModelVersionSummary)) {
            return false;
        }
        AlarmModelVersionSummary other = (AlarmModelVersionSummary) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName()) && Objects.equals(alarmModelArn(), other.alarmModelArn())
                && Objects.equals(alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmModelVersionSummary").add("AlarmModelName", alarmModelName())
                .add("AlarmModelArn", alarmModelArn()).add("AlarmModelVersion", alarmModelVersion()).add("RoleArn", roleArn())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelArn":
            return Optional.ofNullable(clazz.cast(alarmModelArn()));
        case "alarmModelVersion":
            return Optional.ofNullable(clazz.cast(alarmModelVersion()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmModelVersionSummary, T> g) {
        return obj -> g.apply((AlarmModelVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmModelVersionSummary> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The ARN of the alarm model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param alarmModelArn
         *        The ARN of the alarm model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelArn(String alarmModelArn);

        /**
         * <p>
         * The version of the alarm model.
         * </p>
         * 
         * @param alarmModelVersion
         *        The version of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelVersion(String alarmModelVersion);

        /**
         * <p>
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The time the alarm model was created, in the Unix epoch format.
         * </p>
         * 
         * @param creationTime
         *        The time the alarm model was created, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the alarm model was last updated, in the Unix epoch format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The time the alarm model was last updated, in the Unix epoch format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The status of the alarm model. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take
         * up to a few minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
         * model information and update the alarm model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and
         * try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the alarm model. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
         *        take up to a few minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your
         *        alarm model information and update the alarm model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model
         *        information and try again.
         *        </p>
         *        </li>
         * @see AlarmModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the alarm model. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take
         * up to a few minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm
         * model information and update the alarm model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model information and
         * try again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the alarm model. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The alarm model is active and it's ready to evaluate data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can
         *        take up to a few minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code> - The alarm model is inactive, so it isn't ready to evaluate data. Check your
         *        alarm model information and update the alarm model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - You couldn't create or update the alarm model. Check your alarm model
         *        information and try again.
         *        </p>
         *        </li>
         * @see AlarmModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmModelVersionStatus
         */
        Builder status(AlarmModelVersionStatus status);

        /**
         * <p>
         * Contains information about the status of the alarm model version.
         * </p>
         * 
         * @param statusMessage
         *        Contains information about the status of the alarm model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelArn;

        private String alarmModelVersion;

        private String roleArn;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmModelVersionSummary model) {
            alarmModelName(model.alarmModelName);
            alarmModelArn(model.alarmModelArn);
            alarmModelVersion(model.alarmModelVersion);
            roleArn(model.roleArn);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        @Transient
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelArn() {
            return alarmModelArn;
        }

        public final void setAlarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
        }

        @Override
        @Transient
        public final Builder alarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
            return this;
        }

        public final String getAlarmModelVersion() {
            return alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        @Transient
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AlarmModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public AlarmModelVersionSummary build() {
            return new AlarmModelVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
