/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointParams;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIotDataPlaneEndpointProvider
implements IotDataPlaneEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(IotDataPlaneEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(IotDataPlaneEndpointParams params, LocalState locals) {
        RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultIotDataPlaneEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIotDataPlaneEndpointProvider.endpointRule31(params, locals);
    }

    private static RuleResult endpointRule1(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(IotDataPlaneEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultIotDataPlaneEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(IotDataPlaneEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule26(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule27(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule28(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule29(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(IotDataPlaneEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultIotDataPlaneEndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule10(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule11(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(IotDataPlaneEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule18(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule20(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("ca-central-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.ca-central-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-east-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-east-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-east-2.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-west-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-west-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-west-2.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-gov-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-gov-east-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("us-gov-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-gov-west-1.amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule21(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule22(IotDataPlaneEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIotDataPlaneEndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(IotDataPlaneEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultIotDataPlaneEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule25(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule26(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("cn-north-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.ats.iot.cn-north-1.amazonaws.com.cn")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + locals.region() + ".amazonaws.com.cn")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(IotDataPlaneEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule31(IotDataPlaneEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

