/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalPoliciesResponse;
import software.amazon.awssdk.services.iot.model.Policy;

public class ListPrincipalPoliciesIterable
implements SdkIterable<ListPrincipalPoliciesResponse> {
    private final IotClient client;
    private final ListPrincipalPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrincipalPoliciesIterable(IotClient client, ListPrincipalPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrincipalPoliciesResponseFetcher();
    }

    public Iterator<ListPrincipalPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Policy> policies() {
        Function<ListPrincipalPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrincipalPoliciesResponseFetcher
    implements SyncPageFetcher<ListPrincipalPoliciesResponse> {
        private ListPrincipalPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListPrincipalPoliciesResponse nextPage(ListPrincipalPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalPoliciesIterable.this.client.listPrincipalPolicies(ListPrincipalPoliciesIterable.this.firstRequest);
            }
            return ListPrincipalPoliciesIterable.this.client.listPrincipalPolicies((ListPrincipalPoliciesRequest)((Object)ListPrincipalPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

