/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpUrlDestinationSummary;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationStatus;
import software.amazon.awssdk.services.iot.model.VpcDestinationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleDestinationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRuleDestinationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::arn)).setter(TopicRuleDestinationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::statusAsString)).setter(TopicRuleDestinationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::createdAt)).setter(TopicRuleDestinationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::lastUpdatedAt)).setter(TopicRuleDestinationSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::statusReason)).setter(TopicRuleDestinationSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<HttpUrlDestinationSummary> HTTP_URL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpUrlSummary").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::httpUrlSummary)).setter(TopicRuleDestinationSummary.setter(Builder::httpUrlSummary)).constructor(HttpUrlDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlSummary").build()}).build();
    private static final SdkField<VpcDestinationSummary> VPC_DESTINATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcDestinationSummary").getter(TopicRuleDestinationSummary.getter(TopicRuleDestinationSummary::vpcDestinationSummary)).setter(TopicRuleDestinationSummary.setter(Builder::vpcDestinationSummary)).constructor(VpcDestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcDestinationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_REASON_FIELD, HTTP_URL_SUMMARY_FIELD, VPC_DESTINATION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicRuleDestinationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String statusReason;
    private final HttpUrlDestinationSummary httpUrlSummary;
    private final VpcDestinationSummary vpcDestinationSummary;

    private TopicRuleDestinationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusReason = builder.statusReason;
        this.httpUrlSummary = builder.httpUrlSummary;
        this.vpcDestinationSummary = builder.vpcDestinationSummary;
    }

    public final String arn() {
        return this.arn;
    }

    public final TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final HttpUrlDestinationSummary httpUrlSummary() {
        return this.httpUrlSummary;
    }

    public final VpcDestinationSummary vpcDestinationSummary() {
        return this.vpcDestinationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpUrlSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcDestinationSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationSummary)) {
            return false;
        }
        TopicRuleDestinationSummary other = (TopicRuleDestinationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.httpUrlSummary(), other.httpUrlSummary()) && Objects.equals(this.vpcDestinationSummary(), other.vpcDestinationSummary());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRuleDestinationSummary").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("StatusReason", (Object)this.statusReason()).add("HttpUrlSummary", (Object)this.httpUrlSummary()).add("VpcDestinationSummary", (Object)this.vpcDestinationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "httpUrlSummary": {
                return Optional.ofNullable(clazz.cast(this.httpUrlSummary()));
            }
            case "vpcDestinationSummary": {
                return Optional.ofNullable(clazz.cast(this.vpcDestinationSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("httpUrlSummary", HTTP_URL_SUMMARY_FIELD);
        map.put("vpcDestinationSummary", VPC_DESTINATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationSummary, T> g) {
        return obj -> g.apply((TopicRuleDestinationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String statusReason;
        private HttpUrlDestinationSummary httpUrlSummary;
        private VpcDestinationSummary vpcDestinationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationSummary model) {
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.statusReason(model.statusReason);
            this.httpUrlSummary(model.httpUrlSummary);
            this.vpcDestinationSummary(model.vpcDestinationSummary);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final HttpUrlDestinationSummary.Builder getHttpUrlSummary() {
            return this.httpUrlSummary != null ? this.httpUrlSummary.toBuilder() : null;
        }

        public final void setHttpUrlSummary(HttpUrlDestinationSummary.BuilderImpl httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary != null ? httpUrlSummary.build() : null;
        }

        @Override
        public final Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary;
            return this;
        }

        public final VpcDestinationSummary.Builder getVpcDestinationSummary() {
            return this.vpcDestinationSummary != null ? this.vpcDestinationSummary.toBuilder() : null;
        }

        public final void setVpcDestinationSummary(VpcDestinationSummary.BuilderImpl vpcDestinationSummary) {
            this.vpcDestinationSummary = vpcDestinationSummary != null ? vpcDestinationSummary.build() : null;
        }

        @Override
        public final Builder vpcDestinationSummary(VpcDestinationSummary vpcDestinationSummary) {
            this.vpcDestinationSummary = vpcDestinationSummary;
            return this;
        }

        public TopicRuleDestinationSummary build() {
            return new TopicRuleDestinationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRuleDestinationSummary> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(TopicRuleDestinationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder statusReason(String var1);

        public Builder httpUrlSummary(HttpUrlDestinationSummary var1);

        default public Builder httpUrlSummary(Consumer<HttpUrlDestinationSummary.Builder> httpUrlSummary) {
            return this.httpUrlSummary((HttpUrlDestinationSummary)((HttpUrlDestinationSummary.Builder)HttpUrlDestinationSummary.builder().applyMutation(httpUrlSummary)).build());
        }

        public Builder vpcDestinationSummary(VpcDestinationSummary var1);

        default public Builder vpcDestinationSummary(Consumer<VpcDestinationSummary.Builder> vpcDestinationSummary) {
            return this.vpcDestinationSummary((VpcDestinationSummary)((VpcDestinationSummary.Builder)VpcDestinationSummary.builder().applyMutation(vpcDestinationSummary)).build());
        }
    }
}

