/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.LogEventConfiguration;
import software.amazon.awssdk.services.iot.model.LogEventConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetV2LoggingOptionsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, SetV2LoggingOptionsRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(SetV2LoggingOptionsRequest.getter(SetV2LoggingOptionsRequest::roleArn)).setter(SetV2LoggingOptionsRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DEFAULT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLogLevel").getter(SetV2LoggingOptionsRequest.getter(SetV2LoggingOptionsRequest::defaultLogLevelAsString)).setter(SetV2LoggingOptionsRequest.setter(Builder::defaultLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLogLevel").build()}).build();
    private static final SdkField<Boolean> DISABLE_ALL_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disableAllLogs").getter(SetV2LoggingOptionsRequest.getter(SetV2LoggingOptionsRequest::disableAllLogs)).setter(SetV2LoggingOptionsRequest.setter(Builder::disableAllLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableAllLogs").build()}).build();
    private static final SdkField<List<LogEventConfiguration>> EVENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventConfigurations").getter(SetV2LoggingOptionsRequest.getter(SetV2LoggingOptionsRequest::eventConfigurations)).setter(SetV2LoggingOptionsRequest.setter(Builder::eventConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DEFAULT_LOG_LEVEL_FIELD, DISABLE_ALL_LOGS_FIELD, EVENT_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetV2LoggingOptionsRequest.memberNameToFieldInitializer();
    private final String roleArn;
    private final String defaultLogLevel;
    private final Boolean disableAllLogs;
    private final List<LogEventConfiguration> eventConfigurations;

    private SetV2LoggingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.defaultLogLevel = builder.defaultLogLevel;
        this.disableAllLogs = builder.disableAllLogs;
        this.eventConfigurations = builder.eventConfigurations;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final LogLevel defaultLogLevel() {
        return LogLevel.fromValue(this.defaultLogLevel);
    }

    public final String defaultLogLevelAsString() {
        return this.defaultLogLevel;
    }

    public final Boolean disableAllLogs() {
        return this.disableAllLogs;
    }

    public final boolean hasEventConfigurations() {
        return this.eventConfigurations != null && !(this.eventConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LogEventConfiguration> eventConfigurations() {
        return this.eventConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAllLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventConfigurations() ? this.eventConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetV2LoggingOptionsRequest)) {
            return false;
        }
        SetV2LoggingOptionsRequest other = (SetV2LoggingOptionsRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.defaultLogLevelAsString(), other.defaultLogLevelAsString()) && Objects.equals(this.disableAllLogs(), other.disableAllLogs()) && this.hasEventConfigurations() == other.hasEventConfigurations() && Objects.equals(this.eventConfigurations(), other.eventConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"SetV2LoggingOptionsRequest").add("RoleArn", (Object)this.roleArn()).add("DefaultLogLevel", (Object)this.defaultLogLevelAsString()).add("DisableAllLogs", (Object)this.disableAllLogs()).add("EventConfigurations", this.hasEventConfigurations() ? this.eventConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "defaultLogLevel": {
                return Optional.ofNullable(clazz.cast(this.defaultLogLevelAsString()));
            }
            case "disableAllLogs": {
                return Optional.ofNullable(clazz.cast(this.disableAllLogs()));
            }
            case "eventConfigurations": {
                return Optional.ofNullable(clazz.cast(this.eventConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("defaultLogLevel", DEFAULT_LOG_LEVEL_FIELD);
        map.put("disableAllLogs", DISABLE_ALL_LOGS_FIELD);
        map.put("eventConfigurations", EVENT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetV2LoggingOptionsRequest, T> g) {
        return obj -> g.apply((SetV2LoggingOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private String defaultLogLevel;
        private Boolean disableAllLogs;
        private List<LogEventConfiguration> eventConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetV2LoggingOptionsRequest model) {
            super(model);
            this.roleArn(model.roleArn);
            this.defaultLogLevel(model.defaultLogLevel);
            this.disableAllLogs(model.disableAllLogs);
            this.eventConfigurations(model.eventConfigurations);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDefaultLogLevel() {
            return this.defaultLogLevel;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel == null ? null : defaultLogLevel.toString());
            return this;
        }

        public final Boolean getDisableAllLogs() {
            return this.disableAllLogs;
        }

        public final void setDisableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
        }

        @Override
        public final Builder disableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
            return this;
        }

        public final List<LogEventConfiguration.Builder> getEventConfigurations() {
            List<LogEventConfiguration.Builder> result = LogEventConfigurationsCopier.copyToBuilder(this.eventConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventConfigurations(Collection<LogEventConfiguration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = LogEventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        @Override
        public final Builder eventConfigurations(Collection<LogEventConfiguration> eventConfigurations) {
            this.eventConfigurations = LogEventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurations(LogEventConfiguration ... eventConfigurations) {
            this.eventConfigurations(Arrays.asList(eventConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurations(Consumer<LogEventConfiguration.Builder> ... eventConfigurations) {
            this.eventConfigurations(Stream.of(eventConfigurations).map(c -> (LogEventConfiguration)((LogEventConfiguration.Builder)LogEventConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetV2LoggingOptionsRequest build() {
            return new SetV2LoggingOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetV2LoggingOptionsRequest> {
        public Builder roleArn(String var1);

        public Builder defaultLogLevel(String var1);

        public Builder defaultLogLevel(LogLevel var1);

        public Builder disableAllLogs(Boolean var1);

        public Builder eventConfigurations(Collection<LogEventConfiguration> var1);

        public Builder eventConfigurations(LogEventConfiguration ... var1);

        public Builder eventConfigurations(Consumer<LogEventConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

