/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.LogTargetConfiguration;
import software.amazon.awssdk.services.iot.model.LogTargetConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListV2LoggingLevelsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListV2LoggingLevelsResponse> {
    private static final SdkField<List<LogTargetConfiguration>> LOG_TARGET_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logTargetConfigurations").getter(ListV2LoggingLevelsResponse.getter(ListV2LoggingLevelsResponse::logTargetConfigurations)).setter(ListV2LoggingLevelsResponse.setter(Builder::logTargetConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTargetConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogTargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListV2LoggingLevelsResponse.getter(ListV2LoggingLevelsResponse::nextToken)).setter(ListV2LoggingLevelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TARGET_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListV2LoggingLevelsResponse.memberNameToFieldInitializer();
    private final List<LogTargetConfiguration> logTargetConfigurations;
    private final String nextToken;

    private ListV2LoggingLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.logTargetConfigurations = builder.logTargetConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLogTargetConfigurations() {
        return this.logTargetConfigurations != null && !(this.logTargetConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LogTargetConfiguration> logTargetConfigurations() {
        return this.logTargetConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTargetConfigurations() ? this.logTargetConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListV2LoggingLevelsResponse)) {
            return false;
        }
        ListV2LoggingLevelsResponse other = (ListV2LoggingLevelsResponse)((Object)obj);
        return this.hasLogTargetConfigurations() == other.hasLogTargetConfigurations() && Objects.equals(this.logTargetConfigurations(), other.logTargetConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListV2LoggingLevelsResponse").add("LogTargetConfigurations", this.hasLogTargetConfigurations() ? this.logTargetConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logTargetConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logTargetConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logTargetConfigurations", LOG_TARGET_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListV2LoggingLevelsResponse, T> g) {
        return obj -> g.apply((ListV2LoggingLevelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<LogTargetConfiguration> logTargetConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListV2LoggingLevelsResponse model) {
            super(model);
            this.logTargetConfigurations(model.logTargetConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<LogTargetConfiguration.Builder> getLogTargetConfigurations() {
            List<LogTargetConfiguration.Builder> result = LogTargetConfigurationsCopier.copyToBuilder(this.logTargetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogTargetConfigurations(Collection<LogTargetConfiguration.BuilderImpl> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copyFromBuilder(logTargetConfigurations);
        }

        @Override
        public final Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copy(logTargetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(LogTargetConfiguration ... logTargetConfigurations) {
            this.logTargetConfigurations(Arrays.asList(logTargetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder> ... logTargetConfigurations) {
            this.logTargetConfigurations(Stream.of(logTargetConfigurations).map(c -> (LogTargetConfiguration)((LogTargetConfiguration.Builder)LogTargetConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListV2LoggingLevelsResponse build() {
            return new ListV2LoggingLevelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListV2LoggingLevelsResponse> {
        public Builder logTargetConfigurations(Collection<LogTargetConfiguration> var1);

        public Builder logTargetConfigurations(LogTargetConfiguration ... var1);

        public Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

