/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.BatchConfig;
import software.amazon.awssdk.services.iot.model.HeaderListCopier;
import software.amazon.awssdk.services.iot.model.HttpActionHeader;
import software.amazon.awssdk.services.iot.model.HttpAuthorization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpAction> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(HttpAction.getter(HttpAction::url)).setter(HttpAction.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> CONFIRMATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationUrl").getter(HttpAction.getter(HttpAction::confirmationUrl)).setter(HttpAction.setter(Builder::confirmationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationUrl").build()}).build();
    private static final SdkField<List<HttpActionHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headers").getter(HttpAction.getter(HttpAction::headers)).setter(HttpAction.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpActionHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HttpAuthorization> AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("auth").getter(HttpAction.getter(HttpAction::auth)).setter(HttpAction.setter(Builder::auth)).constructor(HttpAuthorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auth").build()}).build();
    private static final SdkField<Boolean> ENABLE_BATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBatching").getter(HttpAction.getter(HttpAction::enableBatching)).setter(HttpAction.setter(Builder::enableBatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBatching").build()}).build();
    private static final SdkField<BatchConfig> BATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchConfig").getter(HttpAction.getter(HttpAction::batchConfig)).setter(HttpAction.setter(Builder::batchConfig)).constructor(BatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CONFIRMATION_URL_FIELD, HEADERS_FIELD, AUTH_FIELD, ENABLE_BATCHING_FIELD, BATCH_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HttpAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String confirmationUrl;
    private final List<HttpActionHeader> headers;
    private final HttpAuthorization auth;
    private final Boolean enableBatching;
    private final BatchConfig batchConfig;

    private HttpAction(BuilderImpl builder) {
        this.url = builder.url;
        this.confirmationUrl = builder.confirmationUrl;
        this.headers = builder.headers;
        this.auth = builder.auth;
        this.enableBatching = builder.enableBatching;
        this.batchConfig = builder.batchConfig;
    }

    public final String url() {
        return this.url;
    }

    public final String confirmationUrl() {
        return this.confirmationUrl;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<HttpActionHeader> headers() {
        return this.headers;
    }

    public final HttpAuthorization auth() {
        return this.auth;
    }

    public final Boolean enableBatching() {
        return this.enableBatching;
    }

    public final BatchConfig batchConfig() {
        return this.batchConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpAction)) {
            return false;
        }
        HttpAction other = (HttpAction)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.confirmationUrl(), other.confirmationUrl()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.enableBatching(), other.enableBatching()) && Objects.equals(this.batchConfig(), other.batchConfig());
    }

    public final String toString() {
        return ToString.builder((String)"HttpAction").add("Url", (Object)this.url()).add("ConfirmationUrl", (Object)this.confirmationUrl()).add("Headers", this.hasHeaders() ? this.headers() : null).add("Auth", (Object)this.auth()).add("EnableBatching", (Object)this.enableBatching()).add("BatchConfig", (Object)this.batchConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "confirmationUrl": {
                return Optional.ofNullable(clazz.cast(this.confirmationUrl()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "enableBatching": {
                return Optional.ofNullable(clazz.cast(this.enableBatching()));
            }
            case "batchConfig": {
                return Optional.ofNullable(clazz.cast(this.batchConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", URL_FIELD);
        map.put("confirmationUrl", CONFIRMATION_URL_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("auth", AUTH_FIELD);
        map.put("enableBatching", ENABLE_BATCHING_FIELD);
        map.put("batchConfig", BATCH_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpAction, T> g) {
        return obj -> g.apply((HttpAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String confirmationUrl;
        private List<HttpActionHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private HttpAuthorization auth;
        private Boolean enableBatching;
        private BatchConfig batchConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpAction model) {
            this.url(model.url);
            this.confirmationUrl(model.confirmationUrl);
            this.headers(model.headers);
            this.auth(model.auth);
            this.enableBatching(model.enableBatching);
            this.batchConfig(model.batchConfig);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getConfirmationUrl() {
            return this.confirmationUrl;
        }

        public final void setConfirmationUrl(String confirmationUrl) {
            this.confirmationUrl = confirmationUrl;
        }

        @Override
        public final Builder confirmationUrl(String confirmationUrl) {
            this.confirmationUrl = confirmationUrl;
            return this;
        }

        public final List<HttpActionHeader.Builder> getHeaders() {
            List<HttpActionHeader.Builder> result = HeaderListCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HttpActionHeader.BuilderImpl> headers) {
            this.headers = HeaderListCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<HttpActionHeader> headers) {
            this.headers = HeaderListCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HttpActionHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HttpActionHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (HttpActionHeader)((HttpActionHeader.Builder)HttpActionHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HttpAuthorization.Builder getAuth() {
            return this.auth != null ? this.auth.toBuilder() : null;
        }

        public final void setAuth(HttpAuthorization.BuilderImpl auth) {
            this.auth = auth != null ? auth.build() : null;
        }

        @Override
        public final Builder auth(HttpAuthorization auth) {
            this.auth = auth;
            return this;
        }

        public final Boolean getEnableBatching() {
            return this.enableBatching;
        }

        public final void setEnableBatching(Boolean enableBatching) {
            this.enableBatching = enableBatching;
        }

        @Override
        public final Builder enableBatching(Boolean enableBatching) {
            this.enableBatching = enableBatching;
            return this;
        }

        public final BatchConfig.Builder getBatchConfig() {
            return this.batchConfig != null ? this.batchConfig.toBuilder() : null;
        }

        public final void setBatchConfig(BatchConfig.BuilderImpl batchConfig) {
            this.batchConfig = batchConfig != null ? batchConfig.build() : null;
        }

        @Override
        public final Builder batchConfig(BatchConfig batchConfig) {
            this.batchConfig = batchConfig;
            return this;
        }

        public HttpAction build() {
            return new HttpAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpAction> {
        public Builder url(String var1);

        public Builder confirmationUrl(String var1);

        public Builder headers(Collection<HttpActionHeader> var1);

        public Builder headers(HttpActionHeader ... var1);

        public Builder headers(Consumer<HttpActionHeader.Builder> ... var1);

        public Builder auth(HttpAuthorization var1);

        default public Builder auth(Consumer<HttpAuthorization.Builder> auth) {
            return this.auth((HttpAuthorization)((HttpAuthorization.Builder)HttpAuthorization.builder().applyMutation(auth)).build());
        }

        public Builder enableBatching(Boolean var1);

        public Builder batchConfig(BatchConfig var1);

        default public Builder batchConfig(Consumer<BatchConfig.Builder> batchConfig) {
            return this.batchConfig((BatchConfig)((BatchConfig.Builder)BatchConfig.builder().applyMutation(batchConfig)).build());
        }
    }
}

