/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary;

public class ListTopicRuleDestinationsIterable
implements SdkIterable<ListTopicRuleDestinationsResponse> {
    private final IotClient client;
    private final ListTopicRuleDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicRuleDestinationsIterable(IotClient client, ListTopicRuleDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTopicRuleDestinationsResponseFetcher();
    }

    public Iterator<ListTopicRuleDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicRuleDestinationSummary> destinationSummaries() {
        Function<ListTopicRuleDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinationSummaries() != null) {
                return response.destinationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTopicRuleDestinationsResponseFetcher
    implements SyncPageFetcher<ListTopicRuleDestinationsResponse> {
        private ListTopicRuleDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicRuleDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTopicRuleDestinationsResponse nextPage(ListTopicRuleDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicRuleDestinationsIterable.this.client.listTopicRuleDestinations(ListTopicRuleDestinationsIterable.this.firstRequest);
            }
            return ListTopicRuleDestinationsIterable.this.client.listTopicRuleDestinations((ListTopicRuleDestinationsRequest)((Object)ListTopicRuleDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

