/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;

public class ListThingsInBillingGroupPublisher
implements SdkPublisher<ListThingsInBillingGroupResponse> {
    private final IotAsyncClient client;
    private final ListThingsInBillingGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingsInBillingGroupPublisher(IotAsyncClient client, ListThingsInBillingGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingsInBillingGroupPublisher(IotAsyncClient client, ListThingsInBillingGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingsInBillingGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingsInBillingGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> things() {
        Function<ListThingsInBillingGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingsInBillingGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingsInBillingGroupResponseFetcher
    implements AsyncPageFetcher<ListThingsInBillingGroupResponse> {
        private ListThingsInBillingGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListThingsInBillingGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingsInBillingGroupResponse> nextPage(ListThingsInBillingGroupResponse previousPage) {
            if (previousPage == null) {
                return ListThingsInBillingGroupPublisher.this.client.listThingsInBillingGroup(ListThingsInBillingGroupPublisher.this.firstRequest);
            }
            return ListThingsInBillingGroupPublisher.this.client.listThingsInBillingGroup((ListThingsInBillingGroupRequest)((Object)ListThingsInBillingGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

