/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.MitigationActionIdentifier;

public class ListMitigationActionsPublisher
implements SdkPublisher<ListMitigationActionsResponse> {
    private final IotAsyncClient client;
    private final ListMitigationActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMitigationActionsPublisher(IotAsyncClient client, ListMitigationActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMitigationActionsPublisher(IotAsyncClient client, ListMitigationActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMitigationActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMitigationActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MitigationActionIdentifier> actionIdentifiers() {
        Function<ListMitigationActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionIdentifiers() != null) {
                return response.actionIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMitigationActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMitigationActionsResponseFetcher
    implements AsyncPageFetcher<ListMitigationActionsResponse> {
        private ListMitigationActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMitigationActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMitigationActionsResponse> nextPage(ListMitigationActionsResponse previousPage) {
            if (previousPage == null) {
                return ListMitigationActionsPublisher.this.client.listMitigationActions(ListMitigationActionsPublisher.this.firstRequest);
            }
            return ListMitigationActionsPublisher.this.client.listMitigationActions((ListMitigationActionsRequest)((Object)ListMitigationActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

