/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.Certificate;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;

public class ListCertificatesByCAIterable
implements SdkIterable<ListCertificatesByCaResponse> {
    private final IotClient client;
    private final ListCertificatesByCaRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCertificatesByCAIterable(IotClient client, ListCertificatesByCaRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCertificatesByCaResponseFetcher();
    }

    public Iterator<ListCertificatesByCaResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Certificate> certificates() {
        Function<ListCertificatesByCaResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCertificatesByCaResponseFetcher
    implements SyncPageFetcher<ListCertificatesByCaResponse> {
        private ListCertificatesByCaResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesByCaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListCertificatesByCaResponse nextPage(ListCertificatesByCaResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesByCAIterable.this.client.listCertificatesByCA(ListCertificatesByCAIterable.this.firstRequest);
            }
            return ListCertificatesByCAIterable.this.client.listCertificatesByCA((ListCertificatesByCaRequest)((Object)ListCertificatesByCAIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

