/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CommandExecutionStatus;
import software.amazon.awssdk.services.iot.model.CommandNamespace;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.SortOrder;
import software.amazon.awssdk.services.iot.model.TimeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommandExecutionsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListCommandExecutionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::maxResults)).setter(ListCommandExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::nextToken)).setter(ListCommandExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::namespaceAsString)).setter(ListCommandExecutionsRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::statusAsString)).setter(ListCommandExecutionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::sortOrderAsString)).setter(ListCommandExecutionsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()}).build();
    private static final SdkField<TimeFilter> STARTED_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("startedTimeFilter").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::startedTimeFilter)).setter(ListCommandExecutionsRequest.setter(Builder::startedTimeFilter)).constructor(TimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedTimeFilter").build()}).build();
    private static final SdkField<TimeFilter> COMPLETED_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("completedTimeFilter").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::completedTimeFilter)).setter(ListCommandExecutionsRequest.setter(Builder::completedTimeFilter)).constructor(TimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedTimeFilter").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::targetArn)).setter(ListCommandExecutionsRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(ListCommandExecutionsRequest.getter(ListCommandExecutionsRequest::commandArn)).setter(ListCommandExecutionsRequest.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, NAMESPACE_FIELD, STATUS_FIELD, SORT_ORDER_FIELD, STARTED_TIME_FILTER_FIELD, COMPLETED_TIME_FILTER_FIELD, TARGET_ARN_FIELD, COMMAND_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCommandExecutionsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final String namespace;
    private final String status;
    private final String sortOrder;
    private final TimeFilter startedTimeFilter;
    private final TimeFilter completedTimeFilter;
    private final String targetArn;
    private final String commandArn;

    private ListCommandExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.namespace = builder.namespace;
        this.status = builder.status;
        this.sortOrder = builder.sortOrder;
        this.startedTimeFilter = builder.startedTimeFilter;
        this.completedTimeFilter = builder.completedTimeFilter;
        this.targetArn = builder.targetArn;
        this.commandArn = builder.commandArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final TimeFilter startedTimeFilter() {
        return this.startedTimeFilter;
    }

    public final TimeFilter completedTimeFilter() {
        return this.completedTimeFilter;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandExecutionsRequest)) {
            return false;
        }
        ListCommandExecutionsRequest other = (ListCommandExecutionsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.startedTimeFilter(), other.startedTimeFilter()) && Objects.equals(this.completedTimeFilter(), other.completedTimeFilter()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.commandArn(), other.commandArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommandExecutionsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Namespace", (Object)this.namespaceAsString()).add("Status", (Object)this.statusAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("StartedTimeFilter", (Object)this.startedTimeFilter()).add("CompletedTimeFilter", (Object)this.completedTimeFilter()).add("TargetArn", (Object)this.targetArn()).add("CommandArn", (Object)this.commandArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "startedTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startedTimeFilter()));
            }
            case "completedTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.completedTimeFilter()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("startedTimeFilter", STARTED_TIME_FILTER_FIELD);
        map.put("completedTimeFilter", COMPLETED_TIME_FILTER_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommandExecutionsRequest, T> g) {
        return obj -> g.apply((ListCommandExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String namespace;
        private String status;
        private String sortOrder;
        private TimeFilter startedTimeFilter;
        private TimeFilter completedTimeFilter;
        private String targetArn;
        private String commandArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandExecutionsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.namespace(model.namespace);
            this.status(model.status);
            this.sortOrder(model.sortOrder);
            this.startedTimeFilter(model.startedTimeFilter);
            this.completedTimeFilter(model.completedTimeFilter);
            this.targetArn(model.targetArn);
            this.commandArn(model.commandArn);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final TimeFilter.Builder getStartedTimeFilter() {
            return this.startedTimeFilter != null ? this.startedTimeFilter.toBuilder() : null;
        }

        public final void setStartedTimeFilter(TimeFilter.BuilderImpl startedTimeFilter) {
            this.startedTimeFilter = startedTimeFilter != null ? startedTimeFilter.build() : null;
        }

        @Override
        public final Builder startedTimeFilter(TimeFilter startedTimeFilter) {
            this.startedTimeFilter = startedTimeFilter;
            return this;
        }

        public final TimeFilter.Builder getCompletedTimeFilter() {
            return this.completedTimeFilter != null ? this.completedTimeFilter.toBuilder() : null;
        }

        public final void setCompletedTimeFilter(TimeFilter.BuilderImpl completedTimeFilter) {
            this.completedTimeFilter = completedTimeFilter != null ? completedTimeFilter.build() : null;
        }

        @Override
        public final Builder completedTimeFilter(TimeFilter completedTimeFilter) {
            this.completedTimeFilter = completedTimeFilter;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommandExecutionsRequest build() {
            return new ListCommandExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommandExecutionsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder namespace(String var1);

        public Builder namespace(CommandNamespace var1);

        public Builder status(String var1);

        public Builder status(CommandExecutionStatus var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder startedTimeFilter(TimeFilter var1);

        default public Builder startedTimeFilter(Consumer<TimeFilter.Builder> startedTimeFilter) {
            return this.startedTimeFilter((TimeFilter)((TimeFilter.Builder)TimeFilter.builder().applyMutation(startedTimeFilter)).build());
        }

        public Builder completedTimeFilter(TimeFilter var1);

        default public Builder completedTimeFilter(Consumer<TimeFilter.Builder> completedTimeFilter) {
            return this.completedTimeFilter((TimeFilter)((TimeFilter.Builder)TimeFilter.builder().applyMutation(completedTimeFilter)).build());
        }

        public Builder targetArn(String var1);

        public Builder commandArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

