/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CACertificateDescription;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.RegistrationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCaCertificateResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeCaCertificateResponse> {
    private static final SdkField<CACertificateDescription> CERTIFICATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateDescription").getter(DescribeCaCertificateResponse.getter(DescribeCaCertificateResponse::certificateDescription)).setter(DescribeCaCertificateResponse.setter(Builder::certificateDescription)).constructor(CACertificateDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDescription").build()}).build();
    private static final SdkField<RegistrationConfig> REGISTRATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("registrationConfig").getter(DescribeCaCertificateResponse.getter(DescribeCaCertificateResponse::registrationConfig)).setter(DescribeCaCertificateResponse.setter(Builder::registrationConfig)).constructor(RegistrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_DESCRIPTION_FIELD, REGISTRATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCaCertificateResponse.memberNameToFieldInitializer();
    private final CACertificateDescription certificateDescription;
    private final RegistrationConfig registrationConfig;

    private DescribeCaCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificateDescription = builder.certificateDescription;
        this.registrationConfig = builder.registrationConfig;
    }

    public final CACertificateDescription certificateDescription() {
        return this.certificateDescription;
    }

    public final RegistrationConfig registrationConfig() {
        return this.registrationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCaCertificateResponse)) {
            return false;
        }
        DescribeCaCertificateResponse other = (DescribeCaCertificateResponse)((Object)obj);
        return Objects.equals(this.certificateDescription(), other.certificateDescription()) && Objects.equals(this.registrationConfig(), other.registrationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCaCertificateResponse").add("CertificateDescription", (Object)this.certificateDescription()).add("RegistrationConfig", (Object)this.registrationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateDescription": {
                return Optional.ofNullable(clazz.cast(this.certificateDescription()));
            }
            case "registrationConfig": {
                return Optional.ofNullable(clazz.cast(this.registrationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certificateDescription", CERTIFICATE_DESCRIPTION_FIELD);
        map.put("registrationConfig", REGISTRATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCaCertificateResponse, T> g) {
        return obj -> g.apply((DescribeCaCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private CACertificateDescription certificateDescription;
        private RegistrationConfig registrationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCaCertificateResponse model) {
            super(model);
            this.certificateDescription(model.certificateDescription);
            this.registrationConfig(model.registrationConfig);
        }

        public final CACertificateDescription.Builder getCertificateDescription() {
            return this.certificateDescription != null ? this.certificateDescription.toBuilder() : null;
        }

        public final void setCertificateDescription(CACertificateDescription.BuilderImpl certificateDescription) {
            this.certificateDescription = certificateDescription != null ? certificateDescription.build() : null;
        }

        @Override
        public final Builder certificateDescription(CACertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return this.registrationConfig != null ? this.registrationConfig.toBuilder() : null;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        @Override
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        @Override
        public DescribeCaCertificateResponse build() {
            return new DescribeCaCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCaCertificateResponse> {
        public Builder certificateDescription(CACertificateDescription var1);

        default public Builder certificateDescription(Consumer<CACertificateDescription.Builder> certificateDescription) {
            return this.certificateDescription((CACertificateDescription)((CACertificateDescription.Builder)CACertificateDescription.builder().applyMutation(certificateDescription)).build());
        }

        public Builder registrationConfig(RegistrationConfig var1);

        default public Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return this.registrationConfig((RegistrationConfig)((RegistrationConfig.Builder)RegistrationConfig.builder().applyMutation(registrationConfig)).build());
        }
    }
}

