/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateStreamResponse> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(CreateStreamResponse.getter(CreateStreamResponse::streamId)).setter(CreateStreamResponse.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamArn").getter(CreateStreamResponse.getter(CreateStreamResponse::streamArn)).setter(CreateStreamResponse.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateStreamResponse.getter(CreateStreamResponse::description)).setter(CreateStreamResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> STREAM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("streamVersion").getter(CreateStreamResponse.getter(CreateStreamResponse::streamVersion)).setter(CreateStreamResponse.setter(Builder::streamVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, STREAM_ARN_FIELD, DESCRIPTION_FIELD, STREAM_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStreamResponse.memberNameToFieldInitializer();
    private final String streamId;
    private final String streamArn;
    private final String description;
    private final Integer streamVersion;

    private CreateStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamId = builder.streamId;
        this.streamArn = builder.streamArn;
        this.description = builder.description;
        this.streamVersion = builder.streamVersion;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final String description() {
        return this.description;
    }

    public final Integer streamVersion() {
        return this.streamVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamResponse)) {
            return false;
        }
        CreateStreamResponse other = (CreateStreamResponse)((Object)obj);
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.streamVersion(), other.streamVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamResponse").add("StreamId", (Object)this.streamId()).add("StreamArn", (Object)this.streamArn()).add("Description", (Object)this.description()).add("StreamVersion", (Object)this.streamVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "streamVersion": {
                return Optional.ofNullable(clazz.cast(this.streamVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("streamId", STREAM_ID_FIELD);
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("streamVersion", STREAM_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamResponse, T> g) {
        return obj -> g.apply((CreateStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String streamId;
        private String streamArn;
        private String description;
        private Integer streamVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamResponse model) {
            super(model);
            this.streamId(model.streamId);
            this.streamArn(model.streamArn);
            this.description(model.description);
            this.streamVersion(model.streamVersion);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStreamVersion() {
            return this.streamVersion;
        }

        public final void setStreamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
        }

        @Override
        public final Builder streamVersion(Integer streamVersion) {
            this.streamVersion = streamVersion;
            return this;
        }

        @Override
        public CreateStreamResponse build() {
            return new CreateStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamResponse> {
        public Builder streamId(String var1);

        public Builder streamArn(String var1);

        public Builder description(String var1);

        public Builder streamVersion(Integer var1);
    }
}

