/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggregationTypeName {
    STATISTICS("Statistics"),
    PERCENTILES("Percentiles"),
    CARDINALITY("Cardinality"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggregationTypeName> VALUE_MAP;
    private final String value;

    private AggregationTypeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggregationTypeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggregationTypeName> knownValues() {
        EnumSet<AggregationTypeName> knownValues = EnumSet.allOf(AggregationTypeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggregationTypeName.class, AggregationTypeName::toString);
    }
}

