/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.LogTargetConfiguration;

public class ListV2LoggingLevelsPublisher
implements SdkPublisher<ListV2LoggingLevelsResponse> {
    private final IotAsyncClient client;
    private final ListV2LoggingLevelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListV2LoggingLevelsPublisher(IotAsyncClient client, ListV2LoggingLevelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListV2LoggingLevelsPublisher(IotAsyncClient client, ListV2LoggingLevelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListV2LoggingLevelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListV2LoggingLevelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LogTargetConfiguration> logTargetConfigurations() {
        Function<ListV2LoggingLevelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logTargetConfigurations() != null) {
                return response.logTargetConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListV2LoggingLevelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListV2LoggingLevelsResponseFetcher
    implements AsyncPageFetcher<ListV2LoggingLevelsResponse> {
        private ListV2LoggingLevelsResponseFetcher() {
        }

        public boolean hasNextPage(ListV2LoggingLevelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListV2LoggingLevelsResponse> nextPage(ListV2LoggingLevelsResponse previousPage) {
            if (previousPage == null) {
                return ListV2LoggingLevelsPublisher.this.client.listV2LoggingLevels(ListV2LoggingLevelsPublisher.this.firstRequest);
            }
            return ListV2LoggingLevelsPublisher.this.client.listV2LoggingLevels((ListV2LoggingLevelsRequest)((Object)ListV2LoggingLevelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

