/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageSummary> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(PackageSummary.getter(PackageSummary::packageName)).setter(PackageSummary.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVersionName").getter(PackageSummary.getter(PackageSummary::defaultVersionName)).setter(PackageSummary.setter(Builder::defaultVersionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(PackageSummary.getter(PackageSummary::creationDate)).setter(PackageSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(PackageSummary.getter(PackageSummary::lastModifiedDate)).setter(PackageSummary.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, DEFAULT_VERSION_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String defaultVersionName;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private PackageSummary(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.defaultVersionName = builder.defaultVersionName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String defaultVersionName() {
        return this.defaultVersionName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageSummary)) {
            return false;
        }
        PackageSummary other = (PackageSummary)obj;
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.defaultVersionName(), other.defaultVersionName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"PackageSummary").add("PackageName", (Object)this.packageName()).add("DefaultVersionName", (Object)this.defaultVersionName()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "defaultVersionName": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("defaultVersionName", DEFAULT_VERSION_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageSummary, T> g) {
        return obj -> g.apply((PackageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageName;
        private String defaultVersionName;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageSummary model) {
            this.packageName(model.packageName);
            this.defaultVersionName(model.defaultVersionName);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getDefaultVersionName() {
            return this.defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public PackageSummary build() {
            return new PackageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageSummary> {
        public Builder packageName(String var1);

        public Builder defaultVersionName(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

