/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.PropagatingAttribute;
import software.amazon.awssdk.services.iot.model.PropagatingAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mqtt5Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mqtt5Configuration> {
    private static final SdkField<List<PropagatingAttribute>> PROPAGATING_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propagatingAttributes").getter(Mqtt5Configuration.getter(Mqtt5Configuration::propagatingAttributes)).setter(Mqtt5Configuration.setter(Builder::propagatingAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatingAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropagatingAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPAGATING_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Mqtt5Configuration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PropagatingAttribute> propagatingAttributes;

    private Mqtt5Configuration(BuilderImpl builder) {
        this.propagatingAttributes = builder.propagatingAttributes;
    }

    public final boolean hasPropagatingAttributes() {
        return this.propagatingAttributes != null && !(this.propagatingAttributes instanceof SdkAutoConstructList);
    }

    public final List<PropagatingAttribute> propagatingAttributes() {
        return this.propagatingAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropagatingAttributes() ? this.propagatingAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mqtt5Configuration)) {
            return false;
        }
        Mqtt5Configuration other = (Mqtt5Configuration)obj;
        return this.hasPropagatingAttributes() == other.hasPropagatingAttributes() && Objects.equals(this.propagatingAttributes(), other.propagatingAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"Mqtt5Configuration").add("PropagatingAttributes", this.hasPropagatingAttributes() ? this.propagatingAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "propagatingAttributes": {
                return Optional.ofNullable(clazz.cast(this.propagatingAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PropagatingAttribute>>> map = new HashMap<String, SdkField<List<PropagatingAttribute>>>();
        map.put("propagatingAttributes", PROPAGATING_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mqtt5Configuration, T> g) {
        return obj -> g.apply((Mqtt5Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PropagatingAttribute> propagatingAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Mqtt5Configuration model) {
            this.propagatingAttributes(model.propagatingAttributes);
        }

        public final List<PropagatingAttribute.Builder> getPropagatingAttributes() {
            List<PropagatingAttribute.Builder> result = PropagatingAttributeListCopier.copyToBuilder(this.propagatingAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropagatingAttributes(Collection<PropagatingAttribute.BuilderImpl> propagatingAttributes) {
            this.propagatingAttributes = PropagatingAttributeListCopier.copyFromBuilder(propagatingAttributes);
        }

        @Override
        public final Builder propagatingAttributes(Collection<PropagatingAttribute> propagatingAttributes) {
            this.propagatingAttributes = PropagatingAttributeListCopier.copy(propagatingAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingAttributes(PropagatingAttribute ... propagatingAttributes) {
            this.propagatingAttributes(Arrays.asList(propagatingAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingAttributes(Consumer<PropagatingAttribute.Builder> ... propagatingAttributes) {
            this.propagatingAttributes(Stream.of(propagatingAttributes).map(c -> (PropagatingAttribute)((PropagatingAttribute.Builder)PropagatingAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Mqtt5Configuration build() {
            return new Mqtt5Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mqtt5Configuration> {
        public Builder propagatingAttributes(Collection<PropagatingAttribute> var1);

        public Builder propagatingAttributes(PropagatingAttribute ... var1);

        public Builder propagatingAttributes(Consumer<PropagatingAttribute.Builder> ... var1);
    }
}

