/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandExecutionStatus {
    CREATED("CREATED"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    REJECTED("REJECTED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandExecutionStatus> VALUE_MAP;
    private final String value;

    private CommandExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandExecutionStatus> knownValues() {
        EnumSet<CommandExecutionStatus> knownValues = EnumSet.allOf(CommandExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandExecutionStatus.class, CommandExecutionStatus::toString);
    }
}

