/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.services.iot.model.VerificationState;
import software.amazon.awssdk.services.iot.model.ViolationEventAdditionalInfo;
import software.amazon.awssdk.services.iot.model.ViolationEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViolationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViolationEvent> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("violationId").getter(ViolationEvent.getter(ViolationEvent::violationId)).setter(ViolationEvent.setter(Builder::violationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ViolationEvent.getter(ViolationEvent::thingName)).setter(ViolationEvent.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityProfileName").getter(ViolationEvent.getter(ViolationEvent::securityProfileName)).setter(ViolationEvent.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("behavior").getter(ViolationEvent.getter(ViolationEvent::behavior)).setter(ViolationEvent.setter(Builder::behavior)).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final SdkField<MetricValue> METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricValue").getter(ViolationEvent.getter(ViolationEvent::metricValue)).setter(ViolationEvent.setter(Builder::metricValue)).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()}).build();
    private static final SdkField<ViolationEventAdditionalInfo> VIOLATION_EVENT_ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("violationEventAdditionalInfo").getter(ViolationEvent.getter(ViolationEvent::violationEventAdditionalInfo)).setter(ViolationEvent.setter(Builder::violationEventAdditionalInfo)).constructor(ViolationEventAdditionalInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventAdditionalInfo").build()}).build();
    private static final SdkField<String> VIOLATION_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("violationEventType").getter(ViolationEvent.getter(ViolationEvent::violationEventTypeAsString)).setter(ViolationEvent.setter(Builder::violationEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventType").build()}).build();
    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verificationState").getter(ViolationEvent.getter(ViolationEvent::verificationStateAsString)).setter(ViolationEvent.setter(Builder::verificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationState").build()}).build();
    private static final SdkField<String> VERIFICATION_STATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("verificationStateDescription").getter(ViolationEvent.getter(ViolationEvent::verificationStateDescription)).setter(ViolationEvent.setter(Builder::verificationStateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationStateDescription").build()}).build();
    private static final SdkField<Instant> VIOLATION_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("violationEventTime").getter(ViolationEvent.getter(ViolationEvent::violationEventTime)).setter(ViolationEvent.setter(Builder::violationEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD, THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, METRIC_VALUE_FIELD, VIOLATION_EVENT_ADDITIONAL_INFO_FIELD, VIOLATION_EVENT_TYPE_FIELD, VERIFICATION_STATE_FIELD, VERIFICATION_STATE_DESCRIPTION_FIELD, VIOLATION_EVENT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViolationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String violationId;
    private final String thingName;
    private final String securityProfileName;
    private final Behavior behavior;
    private final MetricValue metricValue;
    private final ViolationEventAdditionalInfo violationEventAdditionalInfo;
    private final String violationEventType;
    private final String verificationState;
    private final String verificationStateDescription;
    private final Instant violationEventTime;

    private ViolationEvent(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.metricValue = builder.metricValue;
        this.violationEventAdditionalInfo = builder.violationEventAdditionalInfo;
        this.violationEventType = builder.violationEventType;
        this.verificationState = builder.verificationState;
        this.verificationStateDescription = builder.verificationStateDescription;
        this.violationEventTime = builder.violationEventTime;
    }

    public final String violationId() {
        return this.violationId;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String securityProfileName() {
        return this.securityProfileName;
    }

    public final Behavior behavior() {
        return this.behavior;
    }

    public final MetricValue metricValue() {
        return this.metricValue;
    }

    public final ViolationEventAdditionalInfo violationEventAdditionalInfo() {
        return this.violationEventAdditionalInfo;
    }

    public final ViolationEventType violationEventType() {
        return ViolationEventType.fromValue(this.violationEventType);
    }

    public final String violationEventTypeAsString() {
        return this.violationEventType;
    }

    public final VerificationState verificationState() {
        return VerificationState.fromValue(this.verificationState);
    }

    public final String verificationStateAsString() {
        return this.verificationState;
    }

    public final String verificationStateDescription() {
        return this.verificationStateDescription;
    }

    public final Instant violationEventTime() {
        return this.violationEventTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationEvent)) {
            return false;
        }
        ViolationEvent other = (ViolationEvent)obj;
        return Objects.equals(this.violationId(), other.violationId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behavior(), other.behavior()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.violationEventAdditionalInfo(), other.violationEventAdditionalInfo()) && Objects.equals(this.violationEventTypeAsString(), other.violationEventTypeAsString()) && Objects.equals(this.verificationStateAsString(), other.verificationStateAsString()) && Objects.equals(this.verificationStateDescription(), other.verificationStateDescription()) && Objects.equals(this.violationEventTime(), other.violationEventTime());
    }

    public final String toString() {
        return ToString.builder((String)"ViolationEvent").add("ViolationId", (Object)this.violationId()).add("ThingName", (Object)this.thingName()).add("SecurityProfileName", (Object)this.securityProfileName()).add("Behavior", (Object)this.behavior()).add("MetricValue", (Object)this.metricValue()).add("ViolationEventAdditionalInfo", (Object)this.violationEventAdditionalInfo()).add("ViolationEventType", (Object)this.violationEventTypeAsString()).add("VerificationState", (Object)this.verificationStateAsString()).add("VerificationStateDescription", (Object)this.verificationStateDescription()).add("ViolationEventTime", (Object)this.violationEventTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "violationId": {
                return Optional.ofNullable(clazz.cast(this.violationId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behavior()));
            }
            case "metricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
            case "violationEventAdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.violationEventAdditionalInfo()));
            }
            case "violationEventType": {
                return Optional.ofNullable(clazz.cast(this.violationEventTypeAsString()));
            }
            case "verificationState": {
                return Optional.ofNullable(clazz.cast(this.verificationStateAsString()));
            }
            case "verificationStateDescription": {
                return Optional.ofNullable(clazz.cast(this.verificationStateDescription()));
            }
            case "violationEventTime": {
                return Optional.ofNullable(clazz.cast(this.violationEventTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("violationId", VIOLATION_ID_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("behavior", BEHAVIOR_FIELD);
        map.put("metricValue", METRIC_VALUE_FIELD);
        map.put("violationEventAdditionalInfo", VIOLATION_EVENT_ADDITIONAL_INFO_FIELD);
        map.put("violationEventType", VIOLATION_EVENT_TYPE_FIELD);
        map.put("verificationState", VERIFICATION_STATE_FIELD);
        map.put("verificationStateDescription", VERIFICATION_STATE_DESCRIPTION_FIELD);
        map.put("violationEventTime", VIOLATION_EVENT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViolationEvent, T> g) {
        return obj -> g.apply((ViolationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationId;
        private String thingName;
        private String securityProfileName;
        private Behavior behavior;
        private MetricValue metricValue;
        private ViolationEventAdditionalInfo violationEventAdditionalInfo;
        private String violationEventType;
        private String verificationState;
        private String verificationStateDescription;
        private Instant violationEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationEvent model) {
            this.violationId(model.violationId);
            this.thingName(model.thingName);
            this.securityProfileName(model.securityProfileName);
            this.behavior(model.behavior);
            this.metricValue(model.metricValue);
            this.violationEventAdditionalInfo(model.violationEventAdditionalInfo);
            this.violationEventType(model.violationEventType);
            this.verificationState(model.verificationState);
            this.verificationStateDescription(model.verificationStateDescription);
            this.violationEventTime(model.violationEventTime);
        }

        public final String getViolationId() {
            return this.violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final Behavior.Builder getBehavior() {
            return this.behavior != null ? this.behavior.toBuilder() : null;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final MetricValue.Builder getMetricValue() {
            return this.metricValue != null ? this.metricValue.toBuilder() : null;
        }

        public final void setMetricValue(MetricValue.BuilderImpl metricValue) {
            this.metricValue = metricValue != null ? metricValue.build() : null;
        }

        @Override
        public final Builder metricValue(MetricValue metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final ViolationEventAdditionalInfo.Builder getViolationEventAdditionalInfo() {
            return this.violationEventAdditionalInfo != null ? this.violationEventAdditionalInfo.toBuilder() : null;
        }

        public final void setViolationEventAdditionalInfo(ViolationEventAdditionalInfo.BuilderImpl violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo != null ? violationEventAdditionalInfo.build() : null;
        }

        @Override
        public final Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo violationEventAdditionalInfo) {
            this.violationEventAdditionalInfo = violationEventAdditionalInfo;
            return this;
        }

        public final String getViolationEventType() {
            return this.violationEventType;
        }

        public final void setViolationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
        }

        @Override
        public final Builder violationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
            return this;
        }

        @Override
        public final Builder violationEventType(ViolationEventType violationEventType) {
            this.violationEventType(violationEventType == null ? null : violationEventType.toString());
            return this;
        }

        public final String getVerificationState() {
            return this.verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final String getVerificationStateDescription() {
            return this.verificationStateDescription;
        }

        public final void setVerificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
        }

        @Override
        public final Builder verificationStateDescription(String verificationStateDescription) {
            this.verificationStateDescription = verificationStateDescription;
            return this;
        }

        public final Instant getViolationEventTime() {
            return this.violationEventTime;
        }

        public final void setViolationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
        }

        @Override
        public final Builder violationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
            return this;
        }

        public ViolationEvent build() {
            return new ViolationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViolationEvent> {
        public Builder violationId(String var1);

        public Builder thingName(String var1);

        public Builder securityProfileName(String var1);

        public Builder behavior(Behavior var1);

        default public Builder behavior(Consumer<Behavior.Builder> behavior) {
            return this.behavior((Behavior)((Behavior.Builder)Behavior.builder().applyMutation(behavior)).build());
        }

        public Builder metricValue(MetricValue var1);

        default public Builder metricValue(Consumer<MetricValue.Builder> metricValue) {
            return this.metricValue((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(metricValue)).build());
        }

        public Builder violationEventAdditionalInfo(ViolationEventAdditionalInfo var1);

        default public Builder violationEventAdditionalInfo(Consumer<ViolationEventAdditionalInfo.Builder> violationEventAdditionalInfo) {
            return this.violationEventAdditionalInfo((ViolationEventAdditionalInfo)((ViolationEventAdditionalInfo.Builder)ViolationEventAdditionalInfo.builder().applyMutation(violationEventAdditionalInfo)).build());
        }

        public Builder violationEventType(String var1);

        public Builder violationEventType(ViolationEventType var1);

        public Builder verificationState(String var1);

        public Builder verificationState(VerificationState var1);

        public Builder verificationStateDescription(String var1);

        public Builder violationEventTime(Instant var1);
    }
}

