/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ConfidenceLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MachineLearningDetectionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MachineLearningDetectionConfig> {
    private static final SdkField<String> CONFIDENCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confidenceLevel").getter(MachineLearningDetectionConfig.getter(MachineLearningDetectionConfig::confidenceLevelAsString)).setter(MachineLearningDetectionConfig.setter(Builder::confidenceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MachineLearningDetectionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String confidenceLevel;

    private MachineLearningDetectionConfig(BuilderImpl builder) {
        this.confidenceLevel = builder.confidenceLevel;
    }

    public final ConfidenceLevel confidenceLevel() {
        return ConfidenceLevel.fromValue(this.confidenceLevel);
    }

    public final String confidenceLevelAsString() {
        return this.confidenceLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MachineLearningDetectionConfig)) {
            return false;
        }
        MachineLearningDetectionConfig other = (MachineLearningDetectionConfig)obj;
        return Objects.equals(this.confidenceLevelAsString(), other.confidenceLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MachineLearningDetectionConfig").add("ConfidenceLevel", (Object)this.confidenceLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "confidenceLevel": {
                return Optional.ofNullable(clazz.cast(this.confidenceLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("confidenceLevel", CONFIDENCE_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MachineLearningDetectionConfig, T> g) {
        return obj -> g.apply((MachineLearningDetectionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String confidenceLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(MachineLearningDetectionConfig model) {
            this.confidenceLevel(model.confidenceLevel);
        }

        public final String getConfidenceLevel() {
            return this.confidenceLevel;
        }

        public final void setConfidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        @Override
        public final Builder confidenceLevel(String confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            return this;
        }

        @Override
        public final Builder confidenceLevel(ConfidenceLevel confidenceLevel) {
            this.confidenceLevel(confidenceLevel == null ? null : confidenceLevel.toString());
            return this;
        }

        public MachineLearningDetectionConfig build() {
            return new MachineLearningDetectionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MachineLearningDetectionConfig> {
        public Builder confidenceLevel(String var1);

        public Builder confidenceLevel(ConfidenceLevel var1);
    }
}

