/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Statistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Statistics> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(Statistics.getter(Statistics::count)).setter(Statistics.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("average").getter(Statistics.getter(Statistics::average)).setter(Statistics.setter(Builder::average)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sum").getter(Statistics.getter(Statistics::sum)).setter(Statistics.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("minimum").getter(Statistics.getter(Statistics::minimum)).setter(Statistics.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("maximum").getter(Statistics.getter(Statistics::maximum)).setter(Statistics.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()}).build();
    private static final SdkField<Double> SUM_OF_SQUARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sumOfSquares").getter(Statistics.getter(Statistics::sumOfSquares)).setter(Statistics.setter(Builder::sumOfSquares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumOfSquares").build()}).build();
    private static final SdkField<Double> VARIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("variance").getter(Statistics.getter(Statistics::variance)).setter(Statistics.setter(Builder::variance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variance").build()}).build();
    private static final SdkField<Double> STD_DEVIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("stdDeviation").getter(Statistics.getter(Statistics::stdDeviation)).setter(Statistics.setter(Builder::stdDeviation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stdDeviation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, AVERAGE_FIELD, SUM_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, SUM_OF_SQUARES_FIELD, VARIANCE_FIELD, STD_DEVIATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final Double average;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;
    private final Double sumOfSquares;
    private final Double variance;
    private final Double stdDeviation;

    private Statistics(BuilderImpl builder) {
        this.count = builder.count;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.sumOfSquares = builder.sumOfSquares;
        this.variance = builder.variance;
        this.stdDeviation = builder.stdDeviation;
    }

    public final Integer count() {
        return this.count;
    }

    public final Double average() {
        return this.average;
    }

    public final Double sum() {
        return this.sum;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public final Double sumOfSquares() {
        return this.sumOfSquares;
    }

    public final Double variance() {
        return this.variance;
    }

    public final Double stdDeviation() {
        return this.stdDeviation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.sumOfSquares());
        hashCode = 31 * hashCode + Objects.hashCode(this.variance());
        hashCode = 31 * hashCode + Objects.hashCode(this.stdDeviation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.average(), other.average()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.sumOfSquares(), other.sumOfSquares()) && Objects.equals(this.variance(), other.variance()) && Objects.equals(this.stdDeviation(), other.stdDeviation());
    }

    public final String toString() {
        return ToString.builder((String)"Statistics").add("Count", (Object)this.count()).add("Average", (Object)this.average()).add("Sum", (Object)this.sum()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).add("SumOfSquares", (Object)this.sumOfSquares()).add("Variance", (Object)this.variance()).add("StdDeviation", (Object)this.stdDeviation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "average": {
                return Optional.ofNullable(clazz.cast(this.average()));
            }
            case "sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "sumOfSquares": {
                return Optional.ofNullable(clazz.cast(this.sumOfSquares()));
            }
            case "variance": {
                return Optional.ofNullable(clazz.cast(this.variance()));
            }
            case "stdDeviation": {
                return Optional.ofNullable(clazz.cast(this.stdDeviation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private Double average;
        private Double sum;
        private Double minimum;
        private Double maximum;
        private Double sumOfSquares;
        private Double variance;
        private Double stdDeviation;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            this.count(model.count);
            this.average(model.average);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.sumOfSquares(model.sumOfSquares);
            this.variance(model.variance);
            this.stdDeviation(model.stdDeviation);
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Double getAverage() {
            return this.average;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        @Override
        @Transient
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final Double getSum() {
            return this.sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        @Transient
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        @Transient
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        @Transient
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getSumOfSquares() {
            return this.sumOfSquares;
        }

        public final void setSumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
        }

        @Override
        @Transient
        public final Builder sumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
            return this;
        }

        public final Double getVariance() {
            return this.variance;
        }

        public final void setVariance(Double variance) {
            this.variance = variance;
        }

        @Override
        @Transient
        public final Builder variance(Double variance) {
            this.variance = variance;
            return this;
        }

        public final Double getStdDeviation() {
            return this.stdDeviation;
        }

        public final void setStdDeviation(Double stdDeviation) {
            this.stdDeviation = stdDeviation;
        }

        @Override
        @Transient
        public final Builder stdDeviation(Double stdDeviation) {
            this.stdDeviation = stdDeviation;
            return this;
        }

        public Statistics build() {
            return new Statistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Statistics> {
        public Builder count(Integer var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);

        public Builder sumOfSquares(Double var1);

        public Builder variance(Double var1);

        public Builder stdDeviation(Double var1);
    }
}

