/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    THING("THING"),
    THING_GROUP("THING_GROUP"),
    THING_TYPE("THING_TYPE"),
    THING_GROUP_MEMBERSHIP("THING_GROUP_MEMBERSHIP"),
    THING_GROUP_HIERARCHY("THING_GROUP_HIERARCHY"),
    THING_TYPE_ASSOCIATION("THING_TYPE_ASSOCIATION"),
    JOB("JOB"),
    JOB_EXECUTION("JOB_EXECUTION"),
    POLICY("POLICY"),
    CERTIFICATE("CERTIFICATE"),
    CA_CERTIFICATE("CA_CERTIFICATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

