/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.Configuration;
import software.amazon.awssdk.services.iot.model.EventConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.EventType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventConfigurationsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeEventConfigurationsResponse> {
    private static final SdkField<Map<String, Configuration>> EVENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventConfigurations").getter(DescribeEventConfigurationsResponse.getter(DescribeEventConfigurationsResponse::eventConfigurationsAsStrings)).setter(DescribeEventConfigurationsResponse.setter(Builder::eventConfigurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeEventConfigurationsResponse.getter(DescribeEventConfigurationsResponse::creationDate)).setter(DescribeEventConfigurationsResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeEventConfigurationsResponse.getter(DescribeEventConfigurationsResponse::lastModifiedDate)).setter(DescribeEventConfigurationsResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONFIGURATIONS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final Map<String, Configuration> eventConfigurations;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private DescribeEventConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventConfigurations = builder.eventConfigurations;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final Map<EventType, Configuration> eventConfigurations() {
        return EventConfigurationsCopier.copyStringToEnum(this.eventConfigurations);
    }

    public final boolean hasEventConfigurations() {
        return this.eventConfigurations != null && !(this.eventConfigurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, Configuration> eventConfigurationsAsStrings() {
        return this.eventConfigurations;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventConfigurations() ? this.eventConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventConfigurationsResponse)) {
            return false;
        }
        DescribeEventConfigurationsResponse other = (DescribeEventConfigurationsResponse)((Object)obj);
        return this.hasEventConfigurations() == other.hasEventConfigurations() && Objects.equals(this.eventConfigurationsAsStrings(), other.eventConfigurationsAsStrings()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventConfigurationsResponse").add("EventConfigurations", this.hasEventConfigurations() ? this.eventConfigurationsAsStrings() : null).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventConfigurations": {
                return Optional.ofNullable(clazz.cast(this.eventConfigurationsAsStrings()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeEventConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private Map<String, Configuration> eventConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventConfigurationsResponse model) {
            super(model);
            this.eventConfigurationsWithStrings(model.eventConfigurations);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final Map<String, Configuration.Builder> getEventConfigurations() {
            Map<String, Configuration.Builder> result = EventConfigurationsCopier.copyToBuilder(this.eventConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEventConfigurations(Map<String, Configuration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        @Override
        @Transient
        public final Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        @Transient
        public final Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyEnumToString(eventConfigurations);
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeEventConfigurationsResponse build() {
            return new DescribeEventConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventConfigurationsResponse> {
        public Builder eventConfigurationsWithStrings(Map<String, Configuration> var1);

        public Builder eventConfigurations(Map<EventType, Configuration> var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

