/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write data to an Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Action implements SdkPojo, Serializable, ToCopyableBuilder<S3Action.Builder, S3Action> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(S3Action::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(S3Action::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(S3Action::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> CANNED_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cannedAcl").getter(getter(S3Action::cannedAclAsString)).setter(setter(Builder::cannedAcl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cannedAcl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            BUCKET_NAME_FIELD, KEY_FIELD, CANNED_ACL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String bucketName;

    private final String key;

    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys
     * for Amazon S3</a>.
     * </p>
     * 
     * @return The object key. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and
     *         condition keys for Amazon S3</a>.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cannedAclAsString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * @see CannedAccessControlList
     */
    public final CannedAccessControlList cannedAcl() {
        return CannedAccessControlList.fromValue(cannedAcl);
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cannedAclAsString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * @see CannedAccessControlList
     */
    public final String cannedAclAsString() {
        return cannedAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(cannedAclAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(key(), other.key()) && Objects.equals(cannedAclAsString(), other.cannedAclAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Action").add("RoleArn", roleArn()).add("BucketName", bucketName()).add("Key", key())
                .add("CannedAcl", cannedAclAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "cannedAcl":
            return Optional.ofNullable(clazz.cast(cannedAclAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Action, T> g) {
        return obj -> g.apply((S3Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition
         * keys for Amazon S3</a>.
         * </p>
         * 
         * @param key
         *        The object key. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and
         *        condition keys for Amazon S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned
         *        ACLs</a>.
         * @see CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(String cannedAcl);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned
         *        ACLs</a>.
         * @see CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(CannedAccessControlList cannedAcl);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String bucketName;

        private String key;

        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            roleArn(model.roleArn);
            bucketName(model.bucketName);
            key(model.key);
            cannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getCannedAcl() {
            return cannedAcl;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        @Override
        @Transient
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        @Transient
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl == null ? null : cannedAcl.toString());
            return this;
        }

        @Override
        public S3Action build() {
            return new S3Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
